package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.ABCOrderCorrectionDto;
import cn.com.duiba.order.center.api.dto.CorrectCollectDto;

import java.util.Date;
import java.util.List;

/**
 * @author qianjue
 * @date 2019/9/24
 * @description:
 */
@AdvancedFeignClient
public interface RemoteOrderCorrectionService {

    int  insertOrderCorrection(ABCOrderCorrectionDto dto);

    /**
     * 根据日期查询当天的冲正数据
     * @param date
     * @return
     */
    List<CorrectCollectDto> getOrderCorrectCollect(Date date);

    /**
     * 批量查询
     * @param deleted 是否已删除状态
     * @param limit 数量
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     */
    List<ABCOrderCorrectionDto> batchGetCollectsByConditions(int deleted,int limit,Date startDate,Date endDate) throws BizException;


    /**
     * 更新订单状态为已推送
     * @param orderNum
     * @return
     */
    int deleteOrderCorrect(String orderNum);
}
