package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * @author qianjue
 * @date 2018/12/11
 * @description: 订单主类型枚举
 */
public enum OrderTypeEnum {
    //优惠券订单
    COUPON("coupon","优惠券"),
    //支付宝订单
    ALIPAY("alipay","支付宝充值"),
    //虚拟商品
    VIRTURAL("virtual","虚拟商品"),
    //话费
    PHONEBILL("phonebill","话费充值"),
    //流量
    PHONEFLOW("phoneflow","流量充值"),
    //实物
    OBJECT("object","实物"),
    //QB订单
    QB("qb","Q币充值"),
    ;


    private String type;
    private String desc;

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public void setType(String type) {
        this.type = type;
    }

    private OrderTypeEnum(String type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public static OrderTypeEnum ofValue(String type){
        for (OrderTypeEnum orderEnum:values()){
            if (Objects.equals(orderEnum.getType(),type)){
                return orderEnum;
            }
        }
       return null;
    }
}
