package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.order.center.api.tool.SecureTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

/**
 * Created by yansen on 16/10/2.
 */
public class RequestParams implements Serializable {

    private static final long serialVersionUID = 5758075167406488621L;


    public static final String LOCALHOST_IP = "127.0.0" + ".1";

    private String userAgent = "";
    private Long consumerId;
    private String ip;
    private Map<String, String> cookies = Collections.emptyMap();
    private Map<String, String> requestParam = Collections.emptyMap();

    public String getUserAgent() {
        return userAgent;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     *
     * @param name
     * @return
     */
    public String getCookie(String name) {
        return this.cookies.get(name);
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies=cookies;
    }

    public Map<String, String> getCookies() {
        return cookies;
    }

    public Map<String, String> getRequestParam() {
        return requestParam;
    }

    public void setRequestParam(Map<String, String> requestParam) {
        this.requestParam = requestParam;
    }

    /**
     *
     * @param request
     * @return
     */
    public static RequestParams parse(HttpServletRequest request) {
        RequestParams rp = new RequestParams();

        String ua = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank(ua)) {
            rp.userAgent = ua.toLowerCase();
        }

        rp.ip = parseIp(request);

        Map<String, String> cookieMap = parseCookies(request);
        rp.consumerId = parseCid(cookieMap);
        rp.cookies = cookieMap;
        return rp;
    }

    /**
     *
     * @param cookieMap
     * @return
     */
    private static Long parseCid(Map<String, String> cookieMap) {

        String wdata3 = cookieMap.get("wdata3");
        if (wdata3 != null) {
            String content = SecureTool.decryptConsumerCookie(wdata3);
            JSONObject json = JSON.parseObject(content);
            if (new Date().getTime() - json.getLong("time") < 24 * 60 * 60 * 1000L) {// 24小时过期
                return json.getLong("cid");
            }
        } else {
            String jsdata3 = cookieMap.get("jsdata3");
            if (jsdata3 != null) {
                String content = SecureTool.decryptConsumerCookie(jsdata3);
                JSONObject json = JSON.parseObject(content);
                if (new Date().getTime() - json.getLong("time") < 24 * 60 * 60 * 1000L) {// 24小时过期
                    return json.getLong("cid");
                }
            }
        }
        return null;
    }

    /**
     *
     * @param request
     * @return
     */
    private static String parseIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isNotBlank(ip)) {
            String[] ips = ip.trim().split(",");
            int size = ips.length;
            if (size > 0) {
                ip = ips[size - 1].trim();
            }
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = LOCALHOST_IP;
        }
        return ip;
    }

    /**
     *
     * @param request
     * @return
     */
    private static Map<String, String> parseCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        Map<String, String> cookieMap = Maps.newHashMap();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }

}

