package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.ABCOrderCorrectionDto;
import cn.com.duiba.order.center.api.dto.CorrectCollectDto;

import java.util.Date;
import java.util.List;

/**
 * @author qianjue
 * @date 2019/9/24
 * @description:
 */
@AdvancedFeignClient
public interface RemoteOrderCorrectionService {

    int  insertOrderCorrection(ABCOrderCorrectionDto dto);

    /**
     * 根据日期查询当天的冲正数据
     * @param date
     * @return
     */
    List<CorrectCollectDto> getOrderCorrectCollect(Date date);

    /**
     * 批量查询
     * @param deleted 是否已删除状态
     * @param size 每次查询数量
     * @param startId 起始id，不包含
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     * @throws BizException
     */
    List<ABCOrderCorrectionDto> batchGetCollectsByConditions(Long startId,int size,Date startDate,Date endDate,int deleted) throws BizException;

    /**
     * 根据条件查询数量
     * @param deleted 是否已删除状态
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     * @throws BizException
     */
    int countByConditons(int deleted,Date startDate,Date endDate) throws BizException;


    /**
     * 更新订单状态为已推送
     * @param orderNum
     * @return
     */
    int deleteOrderCorrectByNum(String orderNum);

    /**
     * 更新订单状态为已推送
     * @param id
     * @return
     */
    int deleteOrderCorrectById(Long id);
}
