package cn.com.duiba.order.center.api.tool;

import cn.com.duiba.order.center.api.constant.FlowStageConstant;
import cn.com.duiba.order.center.api.constant.OrderTypeEnum;
import cn.com.duiba.order.center.api.constant.StatusIntEnum;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * Created by zhangshun on 2018/12/24,09:33:51.
 */
public class OrderUtils {
    //订单Extra字段的jsonKey
    public static final String GROUP_ID = "groupId";

    private OrderUtils() {

    }

    /**
     * 是否新订单
     *
     * @param order
     * @return
     */
    public static Boolean isNewOrder(OrdersDto order) {
        return Objects.isNull(order.getAppItemId()) && Objects.isNull(order.getItemId());
    }

    public static void setExtraJson(OrdersDto order, String jsonKey, Object jsonValue) {
        JSONObject jsonObject = new JSONObject();
        if(StringUtils.isNotBlank(order.getExtraInfo())){
            jsonObject = JSONObject.parseObject(order.getExtraInfo());
        }
        jsonObject.put(jsonKey, jsonValue);
        order.setExtraInfo(jsonObject.toJSONString());
    }

    public static Long getGroupId(OrdersDto order) {
        if(StringUtils.isNotBlank(order.getExtraInfo())){
            JSONObject jsonObject = JSONObject.parseObject(order.getExtraInfo());
            return jsonObject.getLong(GROUP_ID);
        }
        return null;
    }

    public static StatusIntEnum getStatus(OrdersDto dto, AmbSubOrdersDto subDto) {
        if (Objects.equals(dto.getRelationType(),OrdersDto.RelationTypeGroupBuy) && FlowStageConstant.consumerPayComplete.equals(dto.getFlowworkStage())) {
            //如果是拼团单并且状态是已支付，返回拼团中
            return StatusIntEnum.GROUP_BUYING;
        }
        if (FlowStageConstant.consumerPayStarted.equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_PAY;
        }
        // 买家付款完成, 下个状态为: 等待商家审核
        if (FlowStageConstant.auditStarted.equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_AUDIT;
        }
        //待发货
        if (OrderTypeEnum.OBJECT.getType().equals(dto.getType()) && FlowStageConstant.supplierExchangeStarted.equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_SEND;
        }

        // 成功
        if (FlowStageConstant.successComplete.equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.SUCCESS;
        }
        Integer statusInt = dto.getStatusInt();
        if (statusInt != null && statusInt >= StatusIntEnum.WAIT_PAY.getCode()) {
            //新逻辑 展示 已取消，已失效，异常
            if (FlowStageConstant.failComplete.equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
            // 商家已发货, 下个状态为: 确认收货
            if (FlowStageConstant.afterSendStarted.equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
        } else {
            // 商家已发货, 下个状态为: 确认收货
            if (FlowStageConstant.afterSendStarted.equalsIgnoreCase(dto.getFlowworkStage())) {
                // 已收货
                if (Objects.nonNull(subDto) &&
                        Objects.equals(AmbSubOrdersDto.SubOrdersShipStatusReceived, subDto.getShipStatus())) {
                    return StatusIntEnum.RECEIVE;
                }
                // 已发货
                return StatusIntEnum.WAIT_RECEIVE;
            }
            // 失败
            if (OrdersDto.StatusFAil.equalsIgnoreCase(dto.getStatus()) ||
                    FlowStageConstant.create2Fail.equalsIgnoreCase(dto.getFlowworkStage())) {
                //老的都叫失败
                return StatusIntEnum.FAIL;
            }
        }
        return StatusIntEnum.PROCESSING;
    }

    /**
     * 是否普兑商品
     * @param order
     * @return
     */
    public static boolean isMallOrder(OrdersDto order){
        if(OrdersDto.ChargeModeMall.equals(order.getChargeMode()) || OrdersDto.ChargeModeApi.equals(order.getChargeMode())){
            return true;
        }
        return false;
    }

    /**
     * 是否普兑商品
     * @param chargeMode
     * @return
     */
    public static boolean isMallOrder(String chargeMode){
        if(OrdersDto.ChargeModeMall.equals(chargeMode) || OrdersDto.ChargeModeApi.equals(chargeMode)){
            return true;
        }
        return false;
    }

    /**
     * 是否是兑吧采购商品
     * @param ordersDto
     * @return
     */
    public static boolean isPurchaseOrder(OrdersDto ordersDto) {
        //判断是不是供应商商品
        boolean ret = false;
        //如果是兑吧实物商品
        if(ordersDto.getItemId() != null && StringUtils.isNotBlank(ordersDto.getExtraInfo())){
            JSONObject extra = JSONObject.parseObject(ordersDto.getExtraInfo());
            if(extra != null){
                Long supplierId = extra.getLong("supplierId");
                if(supplierId != null){
                    ret = true;
                }
            }
        }

        return ret;
    }
}
