package cn.com.duiba.order.center.api.dto.common;

import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 分页dto
 *
 * @author ykb
 * @date 2023-02-16
 */
@Getter
@Setter
public class PageDto<T> implements Serializable {

    private static final long serialVersionUID = 1L;
    public static final Long defaultPageNum = 1L;
    public static final Long defaultPageSize = 10L;
    public static final List defaultEmptyList = Lists.newArrayList();
    public static final Long defaultTotalNum = 0L;
    public static final Long defaultTotalPages = 0L;

    /**
     * 当前页
     */
    private Long curPage;

    /**
     * 数量
     */
    private Long size;

    /**
     * 总页数
     */
    private Long totalPage;

    /**
     * 总数量
     */
    private Long total;

    /**
     * 数据集合
     */
    private List<T> data;

    public PageDto(PageInfo<T> page) {
        this.total = page.getTotal();
        this.totalPage = (long) page.getPages();
        this.data = page.getList();
        this.size = (long) page.getPageSize();
        this.curPage = (long) page.getPageNum();
    }

    public <E> PageDto(PageInfo<E> page, List<T> list) {
        this.total = page.getTotal();
        this.totalPage = (long) page.getPages();
        this.data = list;
        this.size = (long) page.getPageSize();
        this.curPage = (long) page.getPageNum();
    }



    public PageDto() {
        this.curPage = defaultPageNum;
        this.size = defaultPageSize;
        this.data = defaultEmptyList;
        this.totalPage = defaultTotalPages;
        this.total = defaultTotalNum;
    }
}
