package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.paramquery.OrderMonthQueryParams;

import java.util.List;

/**
 * @author cmm
 * @description:
 */
@AdvancedFeignClient
public interface RemoteOrderMonthService {


    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="20000")
    List<OrdersDto> selectOrderMonthByConditions(OrderMonthQueryParams params);

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="20000")
    List<OrdersDto> selectOrderMonthByConditionsShoppingTrolley(OrderMonthQueryParams params);

    List<Long> selectAppIdByItemId(Long itemId);

    int countByConditons(OrderMonthQueryParams params);

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="20000")
    List<OrdersDto> selectOrderMonthByConditionsWithAllType(OrderMonthQueryParams params);
}
