package cn.com.duiba.order.center.api.tool;

import org.apache.commons.lang.StringUtils;


/**
 * Created by dugq on 2018/11/30 0030.
 */
public class OrderBizParamUtil {
    private OrderBizParamUtil(){}

    private  static final String SEPARATOR = ":";
    private  static final String SEPARATOR_VIRTUAL = "ψ";

    public static String spliceAliPay(String alipay, String realName, String appName) {
       return String.join(SEPARATOR,alipay,realName,"[" + appName + "]支付宝充值");
    }

    public static AliPayBizParam spliteAliPay(String bizParam) {
        if (StringUtils.isBlank(bizParam)) {
            return null;
        }
        String[] split = bizParam.split(SEPARATOR);
        if (split.length != 3) {
            return new AliPayBizParam();
        }
        return new AliPayBizParam(split[0], split[1], split[2]);
    }

    public static String spliceObjectBizParam(String addrName, String addrPhone, String addrProvince, String addrCity, String addrArea, String addrStreet, String addrDetail) {
        return String.join(SEPARATOR, addrName,  addrPhone,  addrProvince,  addrCity,  addrArea,  addrStreet,  addrDetail);
    }

    public static ObjectBizParam spliteObjectBizParam(String bizParam){
        if (StringUtils.isBlank(bizParam)) {
            return null;
        }
        String[] split = bizParam.split(SEPARATOR);
        if (split.length == 6) {
            return new ObjectBizParam(split[0],split[1], split[2], split[3], split[4], null, split[5]);
        } else if (split.length == 7) {
            return new ObjectBizParam(split[0],split[1], split[2], split[3], split[4], split[5], split[6]);
        } else {
            return new ObjectBizParam();
        }
    }

    public static String splicePhoneBillBizParam(String phone, String phoneCatName, String phoneProvince) {
        return String.join(SEPARATOR, phone, phoneCatName,  phoneProvince);
    }

    public static PhoneBillBizParam splitePhoneBillBizParam(String bizParam) {
        if (StringUtils.isBlank(bizParam)) {
            return null;
        }
        String[] split = bizParam.split(SEPARATOR);
        if (split.length == 3) {
            return new PhoneBillBizParam( split[0],split[1], split[2]);
        } else {
            return new PhoneBillBizParam();
        }
    }



    public static String spliceQBBizParam(String qq) {
        return qq ;
    }

    public static QBBizParam spliteQBBizParam(String bizParam){
        if (StringUtils.isBlank(bizParam)) {
            return null;
        }
        String[] split = bizParam.split(SEPARATOR);
        if (split.length == 1) {
            return new QBBizParam(split[0]);
        } else {
            return new QBBizParam();
        }
    }

    public static String spliceVirtualBizParam(String degreeId,String account) {
        if(StringUtils.isBlank(account)){
            return degreeId;
        }
        return String.join (SEPARATOR_VIRTUAL,degreeId,account);
    }

    public static VirtualBizParam splitVirtualBizParam(String bizParam){
        if (StringUtils.isBlank(bizParam)) {
            return null;
        }
        String[] split = bizParam.split(SEPARATOR_VIRTUAL);
        if (split.length == 1) {
            return new VirtualBizParam(split[0],null);
        }else if(split.length == 2){
            return new VirtualBizParam(split[0],split[1]);
        }else {
            return new VirtualBizParam();
        }
    }




    public static class AliPayBizParam {
        /**
         * 支付账号
         */
        private String alipay;
        /**
         * 支付宝实名
         */
        private String reaName;
        /**
         * app名称
         */
        private String appName;

        public AliPayBizParam() {
        }

        public AliPayBizParam(String alipay, String reaName, String appName) {
            this.alipay = alipay;
            this.reaName = reaName;
            this.appName = appName;
        }

        public String getAlipay() {
            return alipay;
        }

        public String getReaName() {
            return reaName;
        }

        public String getAppName() {
            return appName;
        }
    }

    public static class ObjectBizParam {
        /**
         * 收货人
         */
        private String addrName;
        /**
         * 收货人手机
         */
        private  String addrPhone;
        /**
         * 四级地址： 省
         */
        private String addrProvince;
        /**
         * 四级地址： 市
         */
        private String addrCity;
        /**
         * 四级地址： 区
         */
        private String addrArea;
        /**
         * 四级地址： 街道
         */
        private String addrStreet;
        /**
         * 四级地址： 详细地址
         */
        private String addrDetail;

        public ObjectBizParam(String addrName, String addrPhone, String addrProvince, String addrCity, String addrArea, String addrStreet, String addrDetail) {
            this.addrName = addrName;
            this.addrPhone = addrPhone;
            this.addrProvince = addrProvince;
            this.addrCity = addrCity;
            this.addrArea = addrArea;
            this.addrStreet = addrStreet;
            this.addrDetail = addrDetail;
        }

        public ObjectBizParam() {

        }

        public String getAddrName() {
            return addrName;
        }

        public String getAddrPhone() {
            return addrPhone;
        }

        public String getAddrProvince() {
            return addrProvince;
        }

        public String getAddrCity() {
            return addrCity;
        }

        public String getAddrArea() {
            return addrArea;
        }

        public String getAddrStreet() {
            return addrStreet;
        }

        public String getAddrDetail() {
            return addrDetail;
        }
    }

    public static class PhoneBillBizParam {
        /**
         * 手机号
         */
        private String phone;
        /**
         * 手机号归属地
         */
        private String phoneProvince;
        /**
         * 手机号运营商
         */
        private String phoneCatName;

        public PhoneBillBizParam(String phone, String phoneCatName, String phoneProvince) {
            this.phone = phone;
            this.phoneProvince = phoneProvince;
            this.phoneCatName = phoneCatName;
        }

        public PhoneBillBizParam() {

        }

        public String getPhone() {
            return phone;
        }

        public String getPhoneProvince() {
            return phoneProvince;
        }

        public String getPhoneCatName() {
            return phoneCatName;
        }
    }

    public static class QBBizParam {
        private String qq;

        public QBBizParam(String qq) {
            this.qq = qq;
        }

        public QBBizParam() {

        }

        public String getQq() {
            return qq;
        }
    }

    public static class VirtualBizParam {
        /**
         * 多档位时表示档位id 也是充值金额
         */
        private String degreeId;
        /**
         * 充值账号 可为空
         */
        private String account;

        public VirtualBizParam(String degreeId, String account) {
            this.degreeId = degreeId;
            this.account = account;
        }

        public VirtualBizParam() {

        }

        public String getAccount() {
            return account;
        }

        public String getDegreeId() {
            return degreeId;
        }
    }

}
