package cn.com.duiba.order.center.api.constant;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2018/9/12 0012 11:46
 */

/**
 * 1.PaychannelTyp=developer_cashier的子状态
 * 2.目前只有海底捞使用
 * 3.可以扩展使用
 */
public enum SubPaychannelType {
    //默认值,数据库无此数据
    DEFAULT(0, ""),
    WAP_ALI_PAY(1, "支付宝支付"),
    WECHAT_H5PAY(2, "微信支付"),
    WECHAT_PUB_PAY(3, "微信公众号支付"),
    WECHAT_LITE_PAY(4, "微信小程序支付"),
    CCB(5, "建行支付"),
    ABC(6, "农行支付"),
    HELLO(7, "哈啰支付"),
    CMB_ONE_NET(8, "招行一网通支付"),
    SHOUXIN(9, "首信支付"),
    BOC(10, "中国银行支付"),
    CITIC(11, "中信银行支付"),
    MOCK(12, "MOCK支付"),
    UNION_PAY(13, "云闪付"),
    DUIBA_LIVE_MP_PAY(14, "兑吧直播小程序支付"),
    DUIBA_LIVE_INSTALLMENT_PAY(15, "兑吧直播分期支付"),
    DUIBA_LIVE_BF_PAY(16, "兑吧直播宝付支付"),

    NINGBO_BANK_PAY(17, "宁波银行支付"),


    ICBC_CREDITS(18, "工商银行-积分抵扣"),

    ICBC_ELIFE_PAY_APP(19, "工行e生活支付-app端"),
    ICBC_ELIFE_PAY_WX(20, "工行e生活支付-微信端"),

    HZPSBC_INSTALLMENT_PAY(21, "杭州邮储银行分期支付"),
    ICBC_AP_WX_LITE_PAY(22, "工行聚合支付-微信小程序支付"),
    ICBC_AP_WX_PUB_PAY(23, "工行聚合支付-微信公众号支付"),

    XIB_PAY(24,"厦门国际银行-支付"),

    CIB_PAY_WX(25, "兴业银行支付-微信端"),
    WEIBO_PAY(26, "微博支付"),

    ;

    private Integer code;
    private String desc;

    SubPaychannelType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static SubPaychannelType getEnum(String name) {
        for (SubPaychannelType each : SubPaychannelType.values()) {
            if (each.name().equals(name)) {
                return each;
            }
        }
        return DEFAULT;
    }

    public static SubPaychannelType getEnum(Integer code) {
        for (SubPaychannelType each : SubPaychannelType.values()) {
            if (each.code.equals(code)) {
                return each;
            }
        }
        return DEFAULT;
    }

    /**
     * true=支付宝付款
     *
     * @return
     */
    public boolean isAliPay() {
        return WAP_ALI_PAY.equals(this);
    }
}
