package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by yansen on 16/9/26.
 */
@AdvancedFeignClient
public interface RemoteSupplierOrdersService {
    /**
     *
     * @param supplierOrderDto
     * @return
     * @link 参考迁移至insertSupplierOrder
     */
    @Deprecated
    public DubboResult<SupplierOrderDto> insert(SupplierOrderDto supplierOrderDto);

	/**
     * 创建supplierOrder
     * @param supplierOrderDto
     * @return
     * @throws BizException
     */
    SupplierOrderDto  insertSupplierOrder(SupplierOrderDto supplierOrderDto);

    /**
     *
     * @param supplierOrderDto
     * @return
     */
    @Deprecated
    public DubboResult<Void> update(SupplierOrderDto supplierOrderDto);

	/**
     * 更新supplierOrder信息
     * @param supplierOrderDto
     * @return
     */
    Integer updateSupplierOrder(SupplierOrderDto supplierOrderDto);

    /**
     *
     * @param id
     * @return
     */
    @Deprecated
    public DubboResult<SupplierOrderDto> find(Long id);

	/**
     * 根据id查询supplierOrder信息
     * @param id
     * @return
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
    SupplierOrderDto findById(Long  id);

    /**
     *
     * @param duibaOrderNum
     * @return
     */
    @Deprecated
    public DubboResult<List<SupplierOrderDto>> findAllByDuibaOrderNum(String duibaOrderNum);

	/**
	 * 根据duibaOrderNum查询list
     * @param duibaOrderNum
     * @return
     */
    List<SupplierOrderDto> findListByDuibaOrderNum(String duibaOrderNum);


    List<SupplierOrderDto> findAllByOrderId(Long orderId);

    /**
     *
     * @param duibaOrderNum
     * @return
     */
    @Deprecated
    public DubboResult<SupplierOrderDto> findByDuibaOrderNum(String duibaOrderNum);

	/**
     * 根据duibaOrderNum查询最新的一条的supplierOrder记录
     * @param duibaOrderNum
     * @return
     */
    SupplierOrderDto findOneByDuibaOrderNum(String duibaOrderNum);

    /**
     *
     * @param idList
     * @return
     */
    @Deprecated
    DubboResult<List<SupplierOrderDto>> findALLByIdList(List<Long> idList);

    /**
     * 根据id的集合查询supplierOrder集合
     * @param idList
     * @return
     */
    List<SupplierOrderDto> findListByIdList(List<Long> idList);

	/**
     * 处理supplierOrder的数据
     * 从mysql迁移至hbase
     * @return
     */
    Boolean  moveSupplierOrderData();
}
