package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

public enum OrderItemStatusEnum {
    WAIT_SEND(300,"待发货"),
    SEND(400,"已发货"),
    RECEIVE(500,"已收货"),
    CANCEL_SEND(800,"已取消"),
    // 只作展示，不是子订单状态节点
    CLOSE(801,"已关闭"),
    SUCCESS(900,"交易成功"),
    ;

    private Integer code;
    private String desc;

    OrderItemStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static OrderItemStatusEnum ofValue(Integer code){
        for (OrderItemStatusEnum orderEnum:values()){
            if (Objects.equals(orderEnum.getCode(),code)){
                return orderEnum;
            }
        }
        return null;
    }
}
