package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.order.center.api.constant.OrderPromoTypeEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 *
 * @author JunAngLiu
 * @Title: OrderItemDto
 * @Description: 针对 多商品 订单  子订单 dto
 * @date 2018/6/2913:59
 */
public class OrderItemDto implements Serializable {

    private static final long serialVersionUID = 7648999033042607584L;


    //payStatus 开发者支付状态 目前只有pay_back
    public static final String PayStatusPayback = "payback"; // 交易失败，费用已反冲


    //consumerPayStatus用户付款状态
    public static final String ConsumerPayStatusPayBack = "pay_back";
    //payStatus 开发者支付状态 目前只有pay_back
    public static final String ConsumerPayStatusCreditsPayBack = "credits_pay_back"; // 交易失败，费用已反冲

    //bizParam扩展字段的值
    // 兑吧商品成本价
    public static final String COST_PRICE = "costPrice";
    // 老供应商id
    public static final String SUPPLIER_ID = "supplierId";
    // 新供应商id
    public static final String NEW_SUPPLIER_ID = "newSupplierId";
    // 供应商子订单号
    public static final String SUPPLIER_SUB_ORDER_ID = "supplierSubOrderId";
    // 分销商子订单号
    public static final String DISTRIBUTORS_SUB_ORDER_ID = "distributorsSubOrderId";
    // 原始退款单号
    public static final String RAW_REFUND_NOS = "rawRefundNos";
    // 确认收货标识
    public static final String CONFIRM_RECEIVE = "confirmReceive";
    //开发者供应商信息
    public static final String DEV_SUPPLIER_INFO = "devSupplierInfo";

    /** 供应商满包邮 **/
    // 营销活动id
    public static final String MARKET_ACTIVITY_ID = "marketActivityId";
    // 供应商信息id
    public static final String SUPPLIER_INFO_ID = "supplierInfoId";
    // 运费
    public static final String EXPRESS_PRICE = "expressPrice";
    // 实际分摊运费
    public static final String ACTUAL_EXPRESS_PRICE = "actualExpressPrice";
    // 手续费
    public static final String CHARGE_PRICE = "chargePrice";


    private Long credits;//子订单 消耗 总节分
    private Long ordersItemId;

    private Long orderId;

    private Long consumerId;
    /**
     * 涉及到 价格 ，以 分 为单位
     * */
    private Long price;//单价，以 分 为单位

    private Long itemId;//商品id

    private Long skuId;//兑吧skuid

    private Long appSkuId; //开发者skuId
    private Integer quantity;//数量

    private Long appItemId;//开发者商品id

    private String itemBrief;//商品标题

    /**
     * 是否参与优惠， true 为参与
     * */
    private Boolean promotion ;
    private Long totalPrice;//子订单 应付总价，以 分 为单位
    private Long promotionPrice;//子订单优惠价格，以 分 为单位
    private Long actualPrice;//子订单 实付总价，以 分 为单位

    private OrderPromoTypeEnum orderPromoTypeEnum; //优惠类型枚举
    private Long promoActivityId; //营销活动ID
    private Long promotionCredits;//子订单优惠积分
    private String extraInfo;//子订单扩展信息

    /**
     * 优惠券商品, 具体的优惠券ID
     */
    private Long couponId;

    private Date gmtCreate;

    private Date gmtModified;

    private Integer status;

    private String bizParam;
    //扣开发者账户总金额
    private Integer totalDlpActualPrice;
    //开发者支付状态 目前只有pay_back
    private String payStatus;

    //用户付款状态目前只有pay_back
    private String consumerPayStatus;

    private String error4Consumer;// 给用户的出错提示
    private String error4Developer; // 给开发者的出错提示
    private String error4Admin;// 给兑吧管理员的出错提示

    public Integer getTotalDlpActualPrice() {
        return totalDlpActualPrice;
    }

    public void setTotalDlpActualPrice(Integer totalDlpActualPrice) {
        this.totalDlpActualPrice = totalDlpActualPrice;
    }

    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public String getConsumerPayStatus() {
        return consumerPayStatus;
    }

    public void setConsumerPayStatus(String consumerPayStatus) {
        this.consumerPayStatus = consumerPayStatus;
    }

    public String getError4Consumer() {
        return error4Consumer;
    }

    public void setError4Consumer(String error4Consumer) {
        this.error4Consumer = error4Consumer;
    }

    public String getError4Developer() {
        return error4Developer;
    }

    public void setError4Developer(String error4Developer) {
        this.error4Developer = error4Developer;
    }

    public String getError4Admin() {
        return error4Admin;
    }

    public void setError4Admin(String error4Admin) {
        this.error4Admin = error4Admin;
    }

    public Long getOrdersItemId() {
        return ordersItemId;
    }

    public void setOrdersItemId(Long ordersItemId) {
        this.ordersItemId = ordersItemId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }


    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getAppSkuId() {
        return appSkuId;
    }

    public void setAppSkuId(Long appSkuId) {
        this.appSkuId = appSkuId;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getItemBrief() {
        return itemBrief;
    }

    public void setItemBrief(String itemBrief) {
        this.itemBrief = itemBrief;
    }

    public Boolean getPromotion() {
        return promotion;
    }

    public void setPromotion(Boolean promotion) {
        this.promotion = promotion;
    }

    public OrderPromoTypeEnum getOrderPromoTypeEnum() {
        return orderPromoTypeEnum;
    }

    public void setOrderPromoTypeEnum(OrderPromoTypeEnum orderPromoTypeEnum) {
        this.orderPromoTypeEnum = orderPromoTypeEnum;
    }

    public Long getPromoActivityId() {
        return promoActivityId;
    }

    public void setPromoActivityId(Long promoActivityId) {
        this.promoActivityId = promoActivityId;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Long getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Long totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Long getPromotionPrice() {
        return promotionPrice;
    }

    public void setPromotionPrice(Long promotionPrice) {
        this.promotionPrice = promotionPrice;
    }

    public Long getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Long actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getPromotionCredits() {
        return promotionCredits;
    }

    public void setPromotionCredits(Long promotionCredits) {
        this.promotionCredits = promotionCredits;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBizParam() {
        return bizParam;
    }

    public void setBizParam(String bizParam) {
        this.bizParam = bizParam;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrderItemDto that = (OrderItemDto) o;
        return orderPromoTypeEnum == that.orderPromoTypeEnum &&
                Objects.equals(promoActivityId, that.promoActivityId);
    }

    @Override
    public int hashCode() {

        return Objects.hash(orderPromoTypeEnum, promoActivityId);
    }
}
