package cn.com.duiba.order.center.api.paramquery.common;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 分页入参
 *
 * @author ykb
 * @date 2023-02-16
 */
@Getter
@Setter
@NoArgsConstructor
public class PageParam implements Serializable {

    private static final Pattern humpPattern = Pattern.compile("[A-Z]");

    /**
     * 分页数
     */
    protected Integer pageNo = 1;

    /**
     * 分页大小
     */
    protected Integer pageSize = 20;

    /**
     * 排序字段
     */
    protected String orderBy;

    /**
     * 排序规则(asc:升序 desc:降序)
     */
    protected String desc = "";

    /**
     * 手动构造排序
     *
     * @return {@link String}
     */
    public String getOrderBy() {
        return StringUtils.isBlank(orderBy) ? "" : humpToLine2(orderBy) + " " + getDesc();
    }

    public String getOrderByWithoutLine() {
        return orderBy;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 驼峰转下划线
     *
     * @param str str
     * @return {@link String}
     */
    public static String humpToLine2(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public PageParam(Integer pageNo, Integer pageSize, String orderBy, String desc) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderBy = orderBy;
        this.desc = desc;
    }
}
