/**
 * Project Name:activity-center-api<br>
 * File Name:ParseType.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.constant<br>
 * Date:2017年4月17日上午10:58:28<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.usercenter.api.constant;


public enum DeviceType {
    TUIA_BUILD(-1, "推啊生成"),
    UNKNOW(0, "未知"),
    IMEI(1, "imei"),
    IDFA(2, "idfa"),
    OAID(3,"oaid");

    private Integer type;

    private String  desc;

    /**
     * Creates a new instance of ParseType.
     *
     * @param type
     * @param desc
     */

    DeviceType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static DeviceType getByDesc(String desc){
        for (DeviceType deviceType : DeviceType.values()) {
            if (deviceType.desc.equals(desc)) {
                return deviceType;
            }
        }
        return DeviceType.UNKNOW;
    }


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
