package cn.com.duiba.tuia.activity.usercenter.api.dto.consumer;

import cn.com.duiba.tuia.activity.usercenter.api.common.BaseDto;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2019-08-28
 * @description: 推啊用户
 **/
@Data
public class TuiaConsumerDto extends BaseDto {

    /**
     * 推啊用户id
     */
    private Long consumerId;

    /**
     * 设备号
     */
    private String deviceId;

    /**
     * 电话号码
     */
    private String phoneNumber;

    /**
     * 设备类型：-1-推啊生成,0-未知,1-imei,2-idfa,3-oaid
     */
    private Integer deviceType;

    /**
     * 媒体传参
     */
    private List<String> vagueDeviceIds;

    /**
     * 媒体id-媒体userId 键值对集合
     */
    private List<AppUserMap> appUserMap;

    /**
     * 扩展字段Json
     */
    private List<ExtParam> extParam;

    private Date gmtCreate;

    private Date gmtModify;



    @Data
    public static class ExtParam{
        private String paramKey;
        private Object paramValue;

        public ExtParam() {
        }

        public ExtParam(String paramKey, Object paramValue) {
            this.paramKey = paramKey;
            this.paramValue = paramValue;
        }
    }

    @Data
    public static class AppUserMap{
        private Long appId;
        private String mediaUserId;

        public AppUserMap(){

        }

        public AppUserMap(Long appId, String mediaUserId) {
            this.appId = appId;
            this.mediaUserId = mediaUserId;
        }
    }


}
