package cn.com.duiba.tuia.activity.usercenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.usercenter.api.dto.RewardFactorDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.req.ReqRewardFactor;

import java.util.List;

/**
 * 有推分享奖励系数
 */
@AdvancedFeignClient
public interface RemoteRewardFactorService {

    /**
     * 查询分享奖励系数列表
     *
     * @param req
     * @return
     */
    List<RewardFactorDto> queryList(ReqRewardFactor req);


    /**
     * 新增分享奖励系数
     *
     * @param param
     * @return
     */
    Integer addRewardFactor(RewardFactorDto param);

    /**
     * 查询奖励系数
     * <p>
     * 提供给管理端使用的接口
     *
     * @param curDate
     * @return
     */
    RewardFactorDto queryRewardFactor(String curDate);

    /**
     * 修改奖励系数
     *
     * @param param
     * @return
     */
    Integer updateRewardFactor(RewardFactorDto param);

    /**
     * 查询日期最近的奖励系数
     * <p>
     * 提供给有推的接口
     *
     * @param curDate
     * @return
     */
    RewardFactorDto queryRecentRewardFactor(String curDate);

}
