package cn.com.duiba.tuia.activity.usercenter.api.constant;

import java.util.Arrays;
import java.util.List;

public enum BalanceRecordType {
    FIRST_LOGIN(1, "首次登录奖励"),

    ACTIVITY(2, "活动奖励"),

    MISSION(3, "任务奖励"),

    SURPRISE(4, "惊喜福利"),

    WITHDRAW(5, "提现"),

    GAME(6, "游戏奖励"),

    GAME_CONSUME(7, "游戏消耗"),
    GAME_DAILY_FIRST(8, "每日首次"),
    CREDITS_CONSUME(9, "积分商城消耗"),
    CREDITS_ROLLBACK(10, "积分商城兑换失败回滚"),
    THIRD_TO_TUIA(11, "第三方积分兑换推啊金币"),
    TUIA_TO_THIRD(12, "推啊金币兑换第三方积分消耗"),
    BET2_ALMS(13, "三级押注游戏救济金"),
    GAME_TASK_REWARD(14, "游戏任务奖励"),
    THIRD_AMOUNT_CLEAR(15, "自动兑换账户余额清空"),

    YOUTUI_EACH(20, "每日结算收益"),
    YOUTUI_WITHDRAW(21, "提现"),
    YOUTUI_FIRST(22, "新用户奖励"),
    YOUTUI_WITHDRAW_BACK(23, "回滚"),
    YOUTUI_MISSION(24, "任务奖励"),
    YOUTUI_CDKEY(25, "邀请码奖励"),
    YOUTUI_CONTENT(26, "好友互动奖励"),
    YOUTUI_TRANSFORM_TO(27, "兑换现金"),
    YOUTUI_TRANSFORM_FROM(28, "金币兑换"),
    YOUTUI_COMMUNITY_REWARD(29, "社群奖励"),
    YOUTUI_SIGN_REWARD_GOLD(30, "签到奖励"),//金币
    YOUTUI_SIGN_REWARD_AMOUNT(31, "签到奖励"),//现金
    YOUTUI_HOTTEXT_READ_REWARD(32, "阅读奖励"),
    ;

    private Integer type;
    private String desc;

    BalanceRecordType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;

    }


    static final List<BalanceRecordType> in = Arrays.asList(FIRST_LOGIN, ACTIVITY, MISSION, SURPRISE, GAME, GAME_DAILY_FIRST, CREDITS_ROLLBACK,
            THIRD_TO_TUIA, BET2_ALMS, YOUTUI_EACH, YOUTUI_FIRST, YOUTUI_WITHDRAW_BACK, GAME_TASK_REWARD, YOUTUI_CDKEY, YOUTUI_MISSION, YOUTUI_CONTENT,
            YOUTUI_TRANSFORM_FROM, YOUTUI_COMMUNITY_REWARD,YOUTUI_SIGN_REWARD_GOLD,YOUTUI_SIGN_REWARD_AMOUNT,YOUTUI_HOTTEXT_READ_REWARD);

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    // 1为收入 2为支出
    public static Integer getChangeType(BalanceRecordType balanceRecordType) {
        if (in.contains(balanceRecordType)) {
            return 1;
        } else {
            return 2;
        }
    }

    public static BalanceRecordType getByType(Integer type) {
        for (BalanceRecordType recordType : BalanceRecordType.values()) {
            if (recordType.getType().equals(type)) {
                return recordType;
            }
        }
        return null;
    }

    public static String getDesc(Integer type) {
        for (BalanceRecordType recordType : BalanceRecordType.values()) {
            if (recordType.getType().equals(type)) {
                return recordType.getDesc();
            }
        }
        return null;
    }
}
