/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.usercenter.api.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BatchFunction<dto, id, fDto> {
    private Function<dto, id> getIdFromDtoFunc;
    private Function<fDto, id> getIdFromFDtoFunc;
    private Function<List<id>, List<fDto>> getDtosByIdsFunc;
    private Map<id, fDto> dataMap;
    private List<fDto> dataList;
    private Set<id> ids;

    public BatchFunction(Function<dto, id> getIdFromDtoFunc, Function<fDto, id> getIdFromFDtoFunc, Function<List<id>, List<fDto>> getDtosByIdsFunc) {
        this.getIdFromDtoFunc = getIdFromDtoFunc;
        this.getIdFromFDtoFunc = getIdFromFDtoFunc;
        this.getDtosByIdsFunc = getDtosByIdsFunc;
        this.dataMap = new HashMap<id, fDto>();
        this.ids = new HashSet<id>();
    }

    public void processIdFromEntity(dto d) {
        id id = this.getIdFromDtoFunc.apply(d);
        if (id != null) {
            this.ids.add(id);
        }
    }

    public void processSelectList() {
        if (this.ids.isEmpty()) {
            return;
        }
        this.dataList = this.getDtosByIdsFunc.apply(new ArrayList<id>(this.ids));
    }

    public void processMap() {
        if (this.dataList == null || this.dataList.isEmpty()) {
            return;
        }
        this.dataList.forEach(fDto -> this.dataMap.put(this.getIdFromFDtoFunc.apply(fDto), fDto));
    }

    public fDto getEntityById(id id) {
        if (id == null) {
            return null;
        }
        return this.dataMap.get(id);
    }
}

