/**
 * 文件名： CreateAdverReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月5日 下午2:38:27
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 广告表.
 *
 * @author: leiliang
 * @version:
 */
public class AdvertDto extends BaseDto {

    private static final long   serialVersionUID                 = -4140124221247023188L;

    /** 所有投放平台. */
    public static final int ALL_PALTFORM                     = 0;

    /** ios投放平台. */
    public static final int IOS_PALTFORM                     = 2;

    /** Android投放平台. */
    public static final int ANDROID_PALTFORM                 = 1;

    /** cpc计费方式. */
    public static final int CPC_CHARGE_TYPE                  = 1;

    /** 启用状态. */
    public static final int ENABLE                           = 1;

    /** 暂停状态. */
    public static final int SUSPEND                          = 0;

    /** 审核中. */
    public static final int CHECK_STATUS_ING                 = 0;

    /** 审核通过. */
    public static final int CHECK_STATUS_PASS                = 1;

    /** 审核拒绝. */
    public static final int CHECK_STATUS_REFUSE              = 2;

    /** 有效状态. */
    public static final int VALID_STATUS                     = 1;

    /** 无效(暂停)状态. */
    public static final int INVALID_SUSPEND                  = 2;

    /** 无效(审核中)状态. */
    public static final int INVALID_CHECK_IN                 = 3;

    /** 无效(审核拒绝)状态. */
    public static final int INVALID_CHECK_REFUSE             = 4;

    /** 无效(账号余额不足)状态. */
    public static final int INVALID_BALANCE_NOT_ENOUGH       = 5;

    /** 无效(账号预算不足)状态. */
    public static final int INVALID_BALANCE_BUDGET_SHORTFALL = 6;

    /** 无效(广告预算不足)状态. */
    public static final int INVALID_ADVERT_BUDGET_SHORTFALL  = 7;

    /** 无效(库存不足)状态. */
    public static final int INVALID_INADEQUATE_INVENTORY     = 8;

    /** 无效(非投放日期)状态. */
    public static final int INVALID_NON_DELIVERY_DATE        = 9;

    /** 无效(优惠码失效)状态. */
    public static final int INVALID                          = 10;

    /** 无效(落地页审核被拒绝)状态. */
    public static final int INVALID_LAND_PAGE_CHECK_REFUSE   = 11;

    /** 无效(兑吧广告)状态. */
    public static final int INVALID_DUIBA                    = 0;

    /** 广告来源：广告平台. */
    public static final int     TUIA_ADVERT_SOURCE               = 0;

    /** 广告来源：兑吧商品. */
    public static final int     DUIBA_GOODS_SOURCE               = 1;

    /** 广告来源：兑吧券库. */
    public static final int     DUIBA_COUPON_SOURCE              = 2;

    /** 广告未删除. */
    public static final int     ISDELETED_NOT_DELETED            = 0;

    /** 广告ID. */
    private Long advertId;

    //广告类型
    private Integer advertType;

    //广告推广链接
    private String promoteUrl;

    // 推广链接类型 1：落地页网址，2：落地页名称
    private Integer                  promoteType;

    /** 广告主ID. */
    private Long                accountId;

    /** 名称. */
    private String              name;

    /** 每日预算. */
    private Long                budgetPerDay;

    /** 生效期. */
    private Date                startDate;

    /** 失效期. */
    private Date                endDate;

    /** 级别. */
    private Long                level;

    /** 级别更新时间(毫秒数). */
    private Long                levelUpdateTime;

    /** 启用状态. */
    private Integer             enableStatus;

    /** 审核状态. */
    private Integer             checkStatus;

    //拒绝原因
    private String refuseReason;

    /** 有效状态. */
    private Integer             validStatus;

    /** 是否被删除. */
    private Integer             isDeleted;

    /** 优惠码id. */
    private Long                duibaId;
    /** 广告来源 */
    private Integer             source;

    private Integer           abate;

    /** 是否开启重复曝光：0 否 1是 **/
    private Integer repeatExposure;

    /**广告主*/
    private String companyName;

    /**代理商*/
    private String agentCompanyName;
    
    /**
     * 广告权重
     */
    private BigDecimal advertWeight;

    //是否开启广告失效异常提醒状态,0-关闭，1-开启,默认开启
    private Integer invalidRemindStatus;

    //是否开启广告消耗异常提醒状态,0-关闭，1-开启,默认开启
    private Integer consumeAbnRemindStatus;

    /** 兑吧审核：0：未审，1：已审 */
    private Integer duibaAudit;

    /**是否ocpc有限 1-是 0-否*/
    private Integer ocpcFirst;
    
    /** 福利流量投放：0-否，1-是 **/
    private Integer welfareFlowType;

    private Date editTime;

    public Integer getPromoteType() {
        return promoteType;
    }

    public void setPromoteType(Integer promoteType) {
        this.promoteType = promoteType;
    }

    /** 考核指标类型 */
    private Integer assessType;

    /** 考核成本 */
    private Long assessCost;

    public Integer getAssessType() {
        return assessType;
    }

    public void setAssessType(Integer assessType) {
        this.assessType = assessType;
    }

    public Long getAssessCost() {
        return assessCost;
    }

    public void setAssessCost(Long assessCost) {
        this.assessCost = assessCost;
    }

    public Date getEditTime() {
        return editTime;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }

    /**
     * welfareFlowType.
     *
     * @return the welfareFlowType
     * @since JDK 1.8
     */
    public Integer getWelfareFlowType() {
        return welfareFlowType;
    }

    /**
     * welfareFlowType.
     *
     * @param welfareFlowType the welfareFlowType to set
     * @since JDK 1.8
     */
    public void setWelfareFlowType(Integer welfareFlowType) {
        this.welfareFlowType = welfareFlowType;
    }

    public Integer getOcpcFirst() {
        return ocpcFirst;
    }

    public void setOcpcFirst(Integer ocpcFirst) {
        this.ocpcFirst = ocpcFirst;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    /**
     * duibaAudit.
     *
     * @return  the duibaAudit
     * @since   JDK 1.8
     */
    public Integer getDuibaAudit() {
        return duibaAudit;
    }

    /**
     * duibaAudit.
     *
     * @param   duibaAudit    the duibaAudit to set
     * @since   JDK 1.8
     */
    public void setDuibaAudit(Integer duibaAudit) {
        this.duibaAudit = duibaAudit;
    }

    public Integer getAbate() {
        return abate;
    }

    public void setAbate(Integer abate) {
        this.abate = abate;
    }

    public Integer getInvalidRemindStatus() {
        return invalidRemindStatus;
    }

    public void setInvalidRemindStatus(Integer invalidRemindStatus) {
        this.invalidRemindStatus = invalidRemindStatus;
    }

    public Integer getConsumeAbnRemindStatus() {
        return consumeAbnRemindStatus;
    }

    public void setConsumeAbnRemindStatus(Integer consumeAbnRemindStatus) {
        this.consumeAbnRemindStatus = consumeAbnRemindStatus;
    }

    public BigDecimal getAdvertWeight() {
        return advertWeight;
    }

    public void setAdvertWeight(BigDecimal advertWeight) {
        this.advertWeight = advertWeight;
    }

    /*策略类型,默认人工策略; 0-人工策略, 1-智能策略*/
    private Integer strategyType;

    public Integer getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(Integer strategyType) {
        this.strategyType = strategyType;
    }

    public Integer getRepeatExposure() {
        return repeatExposure;
    }

    public void setRepeatExposure(Integer repeatExposure) {
        this.repeatExposure = repeatExposure;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the name.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name.
     *
     * @param name the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the budget per day.
     *
     * @return the budget per day
     */
    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    /**
     * Sets the budget per day.
     *
     * @param budgetPerDay the budget per day
     */
    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    /**
     * Gets the start date.
     *
     * @return the start date
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * Sets the start date.
     *
     * @param startDate the start date
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets the end date.
     *
     * @return the end date
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * Sets the end date.
     *
     * @param endDate the end date
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /**
     * Gets the level.
     *
     * @return the level
     */
    public Long getLevel() {
        return level;
    }

    /**
     * Sets the level.
     *
     * @param level the level
     */
    public void setLevel(Long level) {
        this.level = level;
    }

    /**
     * Gets the level update time.
     *
     * @return the level update time
     */
    public Long getLevelUpdateTime() {
        return levelUpdateTime;
    }

    /**
     * Sets the level update time.
     *
     * @param levelUpdateTime the level update time
     */
    public void setLevelUpdateTime(Long levelUpdateTime) {
        this.levelUpdateTime = levelUpdateTime;
    }

    /**
     * Gets the enable status.
     *
     * @return the enable status
     */
    public Integer getEnableStatus() {
        return enableStatus;
    }

    /**
     * Sets the enable status.
     *
     * @param enableStatus the enable status
     */
    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    /**
     * Gets the check status.
     *
     * @return the check status
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * Sets the check status.
     *
     * @param checkStatus the check status
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * Gets the valid status.
     *
     * @return the valid status
     */
    public Integer getValidStatus() {
        return validStatus;
    }

    /**
     * Sets the valid status.
     *
     * @param validStatus the valid status
     */
    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    /**
     * Gets the is deleted.
     *
     * @return the checks if is deleted
     */
    public Integer getIsDeleted() {
        return isDeleted;
    }

    /**
     * Sets the is deleted.
     *
     * @param isDeleted the checks if is deleted
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * Gets the account id.
     *
     * @return the account id
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * Sets the account id.
     *
     * @param accountId the account id
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getDuibaId() {
        return duibaId;
    }

    public void setDuibaId(Long duibaId) {
        this.duibaId = duibaId;
    }

    public Integer getSource() {
        return source;
    }


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }


    public void setSource(Integer source) {
        this.source = source;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
