package cn.com.duiba.tuia.core.api.remoteservice.advert;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.AdvertAppPackageDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.UpdateAppPackageResultDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by 李志辉 on 2017-07-10 14:02.
 */
@AdvancedFeignClient
public interface RemoteAdvertAppPackageService {

    /**
     * 更新广告的媒体包
     *
     * @param advertId                   广告id
     * @param advertOrientationPackageId 定向配置id
     * @param appPackageIds              媒体包id列表
     * @return 更新结果 true-成功 false-失败
     */
    @Deprecated
    DubboResult<Boolean> update(Long advertId, Long advertOrientationPackageId, List<Long> appPackageIds);

    /**
     * 根据广告id获取绑定的媒体包列表
     *
     * @param advertId 广告id
     * @return 广告-媒体包对应的关系列表
     */
    DubboResult<List<AdvertAppPackageDto>> getAdvertAppPackageByAdvertId(Long advertId);

    /**
     * 根据广告id获取绑定的媒体包列表
     *
     * @param advertOrientationPackageId 定向配置id
     * @return 广告-定向配置-媒体包对应的关系列表
     */
    DubboResult<List<AdvertAppPackageDto>> getByAdvertOrientationPackageId(Long advertOrientationPackageId);

    /**
     * 根据定向配置ids获取媒体包
     * @param orientationIds
     * @return
     */
    DubboResult<List<AdvertAppPackageDto>> listAdvertAppPackageByOrientationIds(List<Long> orientationIds);
    
    /**
     * 
     * updateAdvertAppPackage:( 更新广告的媒体包, 返回修改的值). <br/>
     *
     * @author chencheng
     * @param advertId
     * @param advertOrientationPackageId
     * @param appPackageIds
     * @return
     * @since JDK 1.8
     */
    UpdateAppPackageResultDto updateAdvertAppPackage(Long advertId, Long advertOrientationPackageId, List<Long> appPackageIds);
}
