package cn.com.duiba.tuia.core.api.remoteservice.mail;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.mail.MailDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/10/12 10:17
 * description:统一的邮件发送服务
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteSendMailService {

    /**
     * 统一的发送邮件接口
     *
     * @param mail 邮件发送实体参数
     * @return true发送成功、false发送失败
     */
    DubboResult<Boolean> sendMail(MailDto mail);
}
