package cn.com.duiba.tuia.core.api.remoteservice.permisson;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.permisson.DataPermissonDto;
import cn.com.duiba.tuia.core.api.dto.req.permission.DataPermissionQueryDto;
import cn.com.duiba.tuia.core.api.enums.permisson.DataPermissonSourceTypeEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 数据权限类型
 * Created by zhengjy on 2017/6/5.
 */
@AdvancedFeignClient
public interface RemoteDataPermissonBackendService {
    /**
     * 插入1
     * @param permissionDto
     * @return
     */
    DubboResult<Long> insert(DataPermissonDto permissionDto);

    /**
     * 批量插入
     * @param List<DatapermissionDto>
     * @return
     */
    DubboResult<Boolean> batchInsert(List<DataPermissonDto> list);

    /**
     * 更新
     * @param permissionDto
     * @return
     */
    DubboResult<Boolean> update(DataPermissonDto permissionDto);

    /**
     * 根据数据源id，数据源类型查询数据权限
     * @param sourceId 数据源id
     * @param sourceTypeEnum
     * @return
     */
    DubboResult<DataPermissonDto> getBySourceIdAndType(Long sourceId, DataPermissonSourceTypeEnum sourceTypeEnum);

    /**
     * 查询代理商广告主ids
     * @param
     * @param mngAccountId
     * @param sourceTypeEnum
     * @return
     */
    DubboResult<List<Long>> getAgentAndAdvertiserIds(Long mngAccountId, DataPermissonSourceTypeEnum sourceTypeEnum);

    /**
     * 查询广告主ids
     * @param
     * @param  mngAccountId
     * @param sourceTypeEnum
     * @return
     */
    DubboResult<List<Long>> getAdvertiserIds(Long mngAccountId, DataPermissonSourceTypeEnum sourceTypeEnum);

    /**
     * 根据当前用户idmngAccountId 和数据类型，查询数据源ids,如sourceTypeEnum = advert，将当前用户有权限的广告ids返回
     * @param  mngAccountId
     * @param sourceTypeEnum
     * @return
     */
    DubboResult<List<Long>> getSourceIds(Long mngAccountId, DataPermissonSourceTypeEnum sourceTypeEnum);

    /**
     * 根据数据源ids，和数据类型 返回数据类型列表，广告列表查询
     * @param sourceIds 数据源ids
     * @param sourceTypeEnum
     * @return
     */
    DubboResult<List<DataPermissonDto>> getBySourceIdsAndSourceType(List<Long> sourceIds, DataPermissonSourceTypeEnum sourceTypeEnum);

    /**
     * 
     * batchupdateOrInsertDataPermisson:(批量更新或插入权限数据). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    DubboResult<Boolean> batchUpdateDataPermisson(List<DataPermissonDto> list);

    List<DataPermissonDto> list(DataPermissionQueryDto queryDto);

    List<DataPermissonDto> selectByCondition(DataPermissonDto queryDto);

    List<Long> selectSourceIdsById(Long aeId, DataPermissonSourceTypeEnum sourceTypeEnum);

    /**
     * 根据ssoid查询 用户名
     */
    List<DataPermissonDto> selectNameBySSOAeIds(List<Long> sooAeIds);
}
