package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.homepage.AdvertTabDataDto;
import cn.com.duiba.tuia.core.api.dto.homepage.AdvertiserTabDataDto;
import cn.com.duiba.tuia.core.api.dto.homepage.HomePageAeLeaderDataDto;
import cn.com.duiba.tuia.core.api.dto.homepage.HomePageDataDto;
import cn.com.duiba.tuia.core.api.dto.req.AeLeaderDataReqDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqHomePageAdvertDataDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqHomePageAdvertiserDataDto;

import java.util.List;

/**
 * Created by huangch on 2018/3/16 17:33
 * description:
 *
 * @since JDK 1.6
 */
@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="10000")
@AdvancedFeignClient
public interface RemoteHomePageService {

    /**
     * 查询AE工作台首页静态汇总数据
     */
    HomePageDataDto queryHomePageStatisticsData(List<Long> advertIds, List<Long> accountIds);

    /**
     * 查询AE工作台首页广告Tab页数据
     */
    PageDto<AdvertTabDataDto> queryHomePageAdvertData(ReqHomePageAdvertDataDto req);

    /**
     * 查询AE工作台首页广告主Tab页数据
     */
    PageDto<AdvertiserTabDataDto> queryAdvertiserData(ReqHomePageAdvertiserDataDto req);

    /**
     * AE关注/取消关注广告主
     *
     * @param focusType  1-加入，2-取消
     * @param ssoAdminId 登录的AE
     */
    Boolean focusAdvertiser(Long advertiserId, Integer focusType, Long ssoAdminId);

    /**
     * 统计AE主管下的AE广告主数据
     */
    HomePageAeLeaderDataDto statisticAeDataByAdminIds(AeLeaderDataReqDto req);

}
