/**
 * 文件名： PageQueryAdvertStatisticsByNameReq.java<br>
 * 此类描述的是：<br>
 * 作者: zufengze<br>
 * 创建时间: 2016年4月1日 下午1:53:11
 */
package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.List;

/**
 * 分页模糊查询广告统计数据.
 *
 * @author: zufengze
 * @version:
 */
@ApiModel("分页模糊查询广告统计数据参数")
public class GetAdvertStatisticsReq extends ByDateQueryReq {

    private static final long serialVersionUID = -6113334378033431586L;

    /** 广告名称. */
    @ApiModelProperty("广告名称")
    private String     advertName;

    /** 广告ID. */
    @ApiModelProperty("广告ID")
    private Long       advertId;

    /** 广告ID集合(用于广告名称模糊查询). */
    @ApiModelProperty(value = "广告ID集合", hidden = true)
    private List<Long> advertIds;

    /** 广告主名称. */
    @ApiModelProperty("广告主名称")
    private String     companyName;

    /** 代理商名称 */
    @ApiModelProperty("代理商名称")
    private String     agentCompanyName;

    @ApiModelProperty("代理商或者广告主邮箱")
    private String email;

    @ApiModelProperty("邮箱所属类型 0-广告主 2-代理商")
    private Integer userType;

    /** 有效状态 @{AdvertValidStatusEnum} */
    @ApiModelProperty("有效状态：1-审核通过，2-暂停状态，3-审核中状态，4-审核拒绝状态，5-账号余额不足状态，6-账号预算不足状态，7-广告预算不足状态")
    private Integer           validStatus;

    //需要查询的天数
    private List<String> curDateList;

    @ApiModelProperty("0-总的、1-杭州推啊、2-霍尔果斯推啊")
    private Integer           effectiveMainType;
    
    @ApiModelProperty("活动类型：0-互动广告，1-展示广告")
    private Integer           activityType;

    @ApiModelProperty("AE名称")
    private String aeName;

    @ApiModelProperty("销售名称")
    private String sellName;

    @ApiModelProperty("行业ID，不传表示查询全部")
    private String tradeNum;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getSellName() {
        return sellName;
    }

    public void setSellName(String sellName) {
        this.sellName = sellName;
    }

    public String getTradeNum() {
        return tradeNum;
    }

    public void setTradeNum(String tradeNum) {
        this.tradeNum = tradeNum;
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public List<String> getCurDateList() {
        return curDateList;
    }

    public void setCurDateList(List<String> curDateList) {
        this.curDateList = curDateList;
    }

    public Integer getEffectiveMainType() {
        return effectiveMainType;
    }

    public void setEffectiveMainType(Integer effectiveMainType) {
        this.effectiveMainType = effectiveMainType;
    }

    /**
     * validStatus.
     *
     * @return the validStatus
     * @since JDK 1.8
     */
    public Integer getValidStatus() {
        return validStatus;
    }

    /**
     * validStatus.
     *
     * @param validStatus the validStatus to set
     * @since JDK 1.8
     */
    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    /**
     * Gets the advert name.
     *
     * @return the advertName
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * Sets the advert name.
     *
     * @param advertName the advertName to set
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.7
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.7
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the companyName.
     *
     * @return the companyName
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Sets the companyName.
     *
     * @param companyName the companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Gets the agentCompanyName.
     *
     * @return the agentCompanyName
     */
    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    /**
     * Sets the agentCompanyName.
     *
     * @param agentCompanyName the agentCompanyName
     */
    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    /**
     * Gets the advert ids.
     *
     * @return the advert ids
     */
    public List<Long> getAdvertIds() {
        return advertIds;
    }

    /**
     * Sets the advert ids.
     *
     * @param advertIds the advert ids
     */
    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }


    /**
     * To string.
     *
     * @return the string
     * @see Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
