package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author:zhangmeng
 * @Date:2018-06-11
 * @Function:操作全局配置流量
 */
public class GlobalFlowConfigDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = -2825546196324136642L;
    /** 全局流量配置的id*/
    private Long id;

    /** 配置条件：1-广告行业标签(只取二级行业标签)；2-广告落地页标签；3-广告来源*/
    private Integer configCondition;

    /** 配置条件对应的值*/
    private String configConditionValue;

    /** 配置项：1-权重；2-发券顺序；3-投放时段；4-地区；5-操作系统*/
    private Integer configItem;

    /** 配置项对应的值，当配置项选中投放时段该列不填充*/
    private String configItemValue;

    /** 是否刪除*/
    private Integer isDeleted;

    public GlobalFlowConfigDto() {
        //do nothing
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getConfigCondition() {
        return configCondition;
    }

    public void setConfigCondition(Integer configCondition) {
        this.configCondition = configCondition;
    }

    public String getConfigConditionValue() {
        return configConditionValue;
    }

    public void setConfigConditionValue(String configConditionValue) {
        this.configConditionValue = configConditionValue;
    }

    public Integer getConfigItem() {
        return configItem;
    }

    public void setConfigItem(Integer configItem) {
        this.configItem = configItem;
    }

    public String getConfigItemValue() {
        return configItemValue;
    }

    public void setConfigItemValue(String configItemValue) {
        this.configItemValue = configItemValue;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
