package cn.com.duiba.tuia.core.api.dto.advert;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 下载类广告包名DO对象
 *
 * @Author chensong
 * @Create 2018-12-17
 */
public class AdvertPackageDto implements Serializable {

    private static final long serialVersionUID = 2868449252423390148L;

    /** 广告id */
    private Long advertId;

    /** 包名 */
    private String packageName;

    /** 应用名称 */
    private String appName;

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public AdvertPackageDto() {
    }

    public AdvertPackageDto(Long advertId, String packageName) {
        this.advertId = advertId;
        this.packageName = packageName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this, false);
    }
}
