package cn.com.duiba.tuia.core.api.enums.statistics;

import cn.com.duiba.tuia.core.api.dto.statistics.TitleHeader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by MichealWang on 2018/9/10 0010.
 */
public enum  AdvertPackageHourStatisticsTitleEnum {

    /**
     * 小时
     */
    TIME_BUCKET(0, "timeBucket", "小时"),

    /**
     * 消费
     */
    CONSUME_TOTAL(0, "consumeTotal", "消费"),

    /**
     * 转化成本（PV）消耗/转化pv
     */
    EFFECT_COST(0, "effectCost", "转化成本（PV）"),

    /**
     * 发券pv
     */
    LAUNCH_COUNT(0, "launchCount", "发券pv"),


    /**
     * 计费点击pv
     */
    EF_CLICK_COUNT(0, "efClickCount", "计费点击pv"),


    /**
     * CTR
     */
    CLICK_RATE(0, "clickRate", "CTR"),


    /**
     * 落地页访问PV
     */
    VISIT_PV(0, "visitPv", "落地页访问PV"),


    /**
     * 落地页到达率
     */
    LOSS(0, "loss", "落地页到达率"),

    /**
     * 转化PV
     */
    EFFECT_PV(0, "effectPv", "转化PV"),

    /**
     * CVR
     */
    CVR(0, "cvr", "CVR"),

    /**
     * 计费点击均价
     */
    AVERAGE_PRICE(3, "averagePrice", "计费点击均价");


    /**
     * 类型：0-公用，1-页面展示标题，2-导出标题,3-转化数据后追加的公用标题，4-转化数据后追加的展示标题，5-转化数据后追加的导出标题
     */
    private Integer type;

    private String code;

    private String desc;

    private AdvertPackageHourStatisticsTitleEnum(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    public static AdvertPackageHourStatisticsTitleEnum getByCode(String code) {
        return enumMap.get(code);
    }

    private static Map<String, AdvertPackageHourStatisticsTitleEnum> enumMap = Maps.newHashMap();

    /**
     * 固定数据标题
     */
    private static List<TitleHeader> advertHourStatisticsTitleList = new ArrayList<>(AdvertPackageHourStatisticsTitleEnum.values().length * 2);
    private static List<TitleHeader> advertHourStatisticsExporyTitleList = new ArrayList<>(AdvertPackageHourStatisticsTitleEnum.values().length * 2);
    private static List<TitleHeader> advertHourOtherTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length);
    private static List<TitleHeader> advertHourOtherExportTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length);

    static {
        for (AdvertPackageHourStatisticsTitleEnum it : AdvertPackageHourStatisticsTitleEnum.values()) {
            enumMap.put(it.getCode(), it);
            switch (it.type) {
                case 0:
                    advertHourStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    advertHourStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 1:
                    advertHourStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 2:
                    advertHourStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 3:
                    advertHourOtherTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 5:
                    advertHourOtherExportTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * getAdvertHourStatisticsTitle:(获取转化标题前固定标题，1-展示，2-导出). <br/>
     *
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    public static List<TitleHeader> getAdvertHourStatisticsTitle(Integer type) {
        if (type.intValue() == 1) {
            return BeanUtils.copyList(advertHourStatisticsTitleList, TitleHeader.class);
        } else {
            return BeanUtils.copyList(advertHourStatisticsExporyTitleList, TitleHeader.class);
        }
    }

    /**
     * addOtherTitle:(其他标题追加，转化数据标题放在这些标题之前). <br/>
     *
     * @param advertHourStatisticsTitle
     * @author chencheng
     * @since JDK 1.8
     */
    public static void addOtherTitle(List<TitleHeader> advertHourStatisticsTitle) {

        advertHourStatisticsTitle.addAll(advertHourOtherTitleList);
    }

    /**
     * addOtherTitle:(转化数据后追加的导出标题). <br/>
     *
     * @param advertDayStatisticsTitle
     * @author chencheng
     * @since JDK 1.8
     */
    public static void addOtherExportTitleList(List<TitleHeader> advertDayStatisticsTitle) {
        advertDayStatisticsTitle.addAll(advertHourOtherExportTitleList);
    }
}