package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertPackageDto;

import java.util.List;

/**
 * 广告包名远程接口
 *
 * @Author chensong
 * @Create 2018-12-17
 */
@AdvancedFeignClient
public interface RemoteAdvertPackageService {

    /**
     * 查询所有的广告包名数据
     * @return
     */
    List<AdvertPackageDto> selectAllAdvertPackage();

    /**
     * 批量insert广告包名数据
     * @param list
     * @return
     */
    int insertBatchAdvertPackage(List<AdvertPackageDto> list);

    /**
     * 根据广告id列表查询广告包名数据
     * @param list
     * @return
     */
    List<AdvertPackageDto> selectAdvertPackageByAdvertIds(List<Long> list);

    /**
     * 批量更新
     * @param list
     * @return
     */
    int updateBatchAdvertPackage(List<AdvertPackageDto> list);

}
