/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteQualificationAuditService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.qualification
 * Date:2017年12月1日上午9:59:03
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.qualification;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqPageQualificationAuditDto;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqQualificationAuditDto;
import cn.com.duiba.tuia.core.api.dto.rsp.account.QualificationAuditDto;

/**
 * ClassName:RemoteQualificationAuditService <br/>
 * Function: 资质审核信息接口. <br/>
 * Date:     2017年12月1日 上午9:59:03 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteQualificationAuditService {

    /**
     * 
     * selectQualificationAudit:(条件查询资质审核信息). <br/>
     *
     * @author chencheng
     * @param query 查询条件
     * @return
     * @since JDK 1.8
     */
    List<QualificationAuditDto> selectQualificationAudit(ReqPageQualificationAuditDto query);

    /**
     * 
     * selectQualificationAudit:(条件查询所有的资质审核信息数量). <br/>
     *
     * @author chencheng
     * @param query 查询条件
     * @return
     * @since JDK 1.8
     */
    Integer selectQualificationAuditCount(ReqPageQualificationAuditDto query);

    /**
     * 
     * updateQualificationAuditBatch:(批量操作资质审核信息). <br/>
     *
     * @author chencheng
     * @param listDto 资质审核信息List
     * @return
     * @since JDK 1.8
     */
    Integer batchModifyQualificationAudit(List<ReqQualificationAuditDto> listDto);
    
    /**
     * 
     * updateQualificationAudit:(修改资质审核信息). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    Integer updateQualificationAudit(ReqQualificationAuditDto query);
}

