package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2018年03月08日 13:57
 * @descript:
 * @version: 1.0
 */
public class GetSlotStatisticsReq extends ByDateQueryReq implements Serializable {

    private static final long serialVersionUID = -9087358205321640791L;

    /** 应用ID. */
    @ApiModelProperty("应用ID")
    private Long       appId;

    /** 应用名称. */
    @ApiModelProperty("应用名称")
    private String     appName;

    @ApiModelProperty("标签ID")
    private Long tagId;

    @ApiModelProperty("模块ID")
    private Integer blockId;

    /** 广告ID. */
    @ApiModelProperty("广告ID")
    private Long       advertId;

    /** 数据类型 :null-全部; 1-付费券; 2-免费券 */
    @ApiModelProperty("数据类型 :null-全部; 1-付费券; 2-免费券")
    private Integer dataType;

    private List<Long> slotIds;

    @ApiModelProperty("活动类型：0-互动广告，1-展示广告 2-激励广告")
    private Integer           activityType;

    @ApiModelProperty("广告名称")
    private String advertName;

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Integer getBlockId() {
        return blockId;
    }

    public void setBlockId(Integer blockId) {
        this.blockId = blockId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }
}
