package cn.com.duiba.tuia.core.api.dto;

import cn.com.duiba.tuia.core.api.dto.rsp.RspAppSlotDto;
import com.google.common.base.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.List;

public class AdvertLimitDto extends BaseDto {

	private static final long serialVersionUID = -9055767408780966825L;
	
	/** advert表的主键 */
	private Long advertId;
	
	/** 日预算 */
	private Integer dailyBudget;
	
	/** 生效开始时间 */
	private String startDate;
	
	/** 生效结束时间 */
	private String endDate;
	
	/** 周期星期 */
	private String cyclicityWeek;
	
	/** 应用主键 */
	private Long appId;
	
	/** 应用名称 */
	private String appName;

	private String tagName;
	
	/** 应用账号 */
	private String appAccount;
	
	/** 应用来源 */
	private Integer appSource;

	/**
	 * 应用状态
	 */
	private Integer appStatus;

	/**
	 * 广告位状态：1-不限 2-自定义
	 */
	private Integer soltStatus;

	/**
	 * 昨日CVR
	 */
	private Double yesterdayCVR;

	/**
	 * 昨日发券量
	 */
	private Long yesterLaunch;
	
	/** 是否存在 */
	private boolean relateStatus;
	
	/**定向包ID*/
	private Long orientPkgId;

	private Integer isSlotAll;

	/**
	 * 是否是流量包
	 */
	private Boolean ifAppPackage;

	/**
	 * 媒体广告位
	 */
	private List<RspAppSlotDto> rspAppSoltDtoList;

	/**
	 * 是否是自动添加的限流媒体
	 */
	private Integer autoLimitApp;

	public Integer getAutoLimitApp() {
		return autoLimitApp;
	}

	public void setAutoLimitApp(Integer autoLimitApp) {
		this.autoLimitApp = autoLimitApp;
	}

	public Boolean getIfAppPackage() {
		return ifAppPackage;
	}

	public void setIfAppPackage(Boolean ifAppPackage) {
		this.ifAppPackage = ifAppPackage;
	}

	public Long getAdvertId() {
		return advertId;
	}

	public void setAdvertId(Long advertId) {
		this.advertId = advertId;
	}

	public Integer getDailyBudget() {
		return dailyBudget;
	}

	public void setDailyBudget(Integer dailyBudget) {
		this.dailyBudget = dailyBudget;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getCyclicityWeek() {
		return cyclicityWeek;
	}

	public void setCyclicityWeek(String cyclicityWeek) {
		this.cyclicityWeek = cyclicityWeek;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppAccount() {
		return appAccount;
	}

	public void setAppAccount(String appAccount) {
		this.appAccount = appAccount;
	}

	public Integer getAppSource() {
		return appSource;
	}

	public void setAppSource(Integer appSource) {
		this.appSource = appSource;
	}

	public boolean isRelateStatus() {
		return relateStatus;
	}

	public void setRelateStatus(boolean relateStatus) {
		this.relateStatus = relateStatus;
	}

	public Long getOrientPkgId() {
		return orientPkgId;
	}

	public void setOrientPkgId(Long orientPkgId) {
		this.orientPkgId = orientPkgId;
	}

	public String getTagName() {
		return tagName;
	}

	public void setTagName(String tagName) {
		this.tagName = tagName;
	}

	public List<RspAppSlotDto> getRspAppSoltDtoList() {
		return rspAppSoltDtoList;
	}

	public void setRspAppSoltDtoList(List<RspAppSlotDto> rspAppSoltDtoList) {
		this.rspAppSoltDtoList = rspAppSoltDtoList;
	}

	public Double getYesterdayCVR() {
		return yesterdayCVR;
	}

	public void setYesterdayCVR(Double yesterdayCVR) {
		this.yesterdayCVR = yesterdayCVR;
	}

	public Long getYesterLaunch() {
		return yesterLaunch;
	}

	public void setYesterLaunch(Long yesterLaunch) {
		this.yesterLaunch = yesterLaunch;
	}

	public Integer getAppStatus() {
		return appStatus;
	}

	public void setAppStatus(Integer appStatus) {
		this.appStatus = appStatus;
	}

	public Integer getIsSlotAll() {
		return isSlotAll;
	}

	public void setIsSlotAll(Integer isSlotAll) {
		this.isSlotAll = isSlotAll;
	}

	public Integer getSoltStatus() {
		return soltStatus;
	}

	public void setSoltStatus(Integer soltStatus) {
		this.soltStatus = soltStatus;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		AdvertLimitDto that = (AdvertLimitDto) o;

		if(!Objects.equal(dailyBudget,that.dailyBudget)) return false;
		if(!Objects.equal(startDate,that.startDate)) return false;
		if(!Objects.equal(endDate,that.endDate)) return false;
		if(!Objects.equal(cyclicityWeek,that.cyclicityWeek)) return false;
		if(!Objects.equal(appId,that.appId)) return false;
		if(!Objects.equal(appName,that.appName)) return false;
		if(!Objects.equal(appAccount,that.appAccount)) return false;
		return Objects.equal(appSource,that.appSource);
	}

	@Override
	public int hashCode() {
		int result = dailyBudget != null ? dailyBudget.hashCode() : 0;
		result = 31 * result + (startDate != null ? startDate.hashCode() : 0);
		result = 31 * result + (endDate != null ? endDate.hashCode() : 0);
		result = 31 * result + (cyclicityWeek != null ? cyclicityWeek.hashCode() : 0);
		result = 31 * result + (appId != null ? appId.hashCode() : 0);
		result = 31 * result + (appName != null ? appName.hashCode() : 0);
		result = 31 * result + (appAccount != null ? appAccount.hashCode() : 0);
		result = 31 * result + (appSource != null ? appSource.hashCode() : 0);
		return result;
	}
}
