/**
 * Project Name:tuia-core-api<br>
 * File Name:ReqSelectEmployees.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.req<br>
 * Date:2016年9月7日下午1:49:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.req;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseQueryDto;

/**
 * ClassName: ReqSelectEmployees <br/>
 * Function: 查询协作员列表请求参数. <br/>
 * date: 2016年9月7日 下午1:49:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class ReqSelectEmployees extends BaseQueryDto {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** 代理商ID. */
    private Long              agentId;

    /** 角色ID. */
    private Long              roleId;

    /** 启用状态. */
    private Integer           enableStatus;

    /** 账号. */
    private String            email;

    /** 名称. */
    private String            name;

    /** 操作员ID集合. */
    private List<Long>        operIds;

    /**
     * Gets the agent id.
     *
     * @return the agent id
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * Sets the agent id.
     *
     * @param agentId the agent id
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * Gets the role id.
     *
     * @return the role id
     */
    public Long getRoleId() {
        return roleId;
    }

    /**
     * Sets the role id.
     *
     * @param roleId the role id
     */
    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    /**
     * Gets the enable status.
     *
     * @return the enable status
     */
    public Integer getEnableStatus() {
        return enableStatus;
    }

    /**
     * Sets the enable status.
     *
     * @param enableStatus the enable status
     */
    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    /**
     * Gets the email.
     *
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * Sets the email.
     *
     * @param email the email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Gets the name.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name.
     *
     * @param name the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the oper ids.
     *
     * @return the oper ids
     */
    public List<Long> getOperIds() {
        return operIds;
    }

    /**
     * Sets the oper ids.
     *
     * @param operIds the oper ids
     */
    public void setOperIds(List<Long> operIds) {
        this.operIds = operIds;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
