package cn.com.duiba.tuia.core.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * ClassName: StatisticsOrderEnum <br/>
 * Function: 排序字段. <br/>
 * date: 2017年7月31日 下午4:41:03 <br/>
 *
 * @author chencheng
 * @version
 */
public enum StatisticsOrderEnum {

    /** 消耗 */
    CONSUME_TOTAL("consumeTotal", "消耗"),
    
    /** 发券 */
    LAUNCH_COUNT("launchCount", "发券"),
    
    /** 曝光 */
    EXPOSURE_COUNT("exposureCount", "曝光"),
    
    /** 点击 */
    CLICK_COUNT("clickCount", "点击"),
    
    /** 有效点击 */
    EFCLICK_COUNT("efClickCount", "有效点击"),
    
    /** 点击UV */
    CLICK_UV("clickUV", "点击UV"),
    
    /** 点击率 */
    CLICK_RATE("clickRate", "点击率"),
    
    /** 落地页访问pv */
    VISIT_PV("visitPv", "落地页访问pv"),
    
    /** 落地页效果pv */
    EFFECT_PV("effectPv", "落地页效果pv"),

    /** 落地页到达率 */
    LOSS("loss", "落地页到达率"),

    /** 点击均价 */
    AVERAGE_PRICE("averagePrice", "点击均价"),

    /** 广告出价 */
    FEE("fee", "广告出价"),
    
    /** 时间段 */
    TIMEBUCKET("timeBucket", "时间段"),
    
    /** 日期 */
    DATE("curDate", "日期"),
    /** CVR */

    CVR("cvr", "CVR"),
    /** 转化成本*/
    EFFECT_COST("effectCost", "转化成本"),

    /** 默认 */
    DEFAULT("default", "默认");

    private String desc;

    private String code;

    StatisticsOrderEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, StatisticsOrderEnum> enumMap = Maps.newHashMap();
    static {
        for (StatisticsOrderEnum it : StatisticsOrderEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static StatisticsOrderEnum getByName(String code) {
        return enumMap.get(code) != null ? enumMap.get(code) : StatisticsOrderEnum.DEFAULT;
    }
}
