package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertLimitDto;
import cn.com.duiba.tuia.core.api.dto.AdvertOrientationPackageDto;
import cn.com.duiba.tuia.core.api.dto.MediaAdvertApplyDetailDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqMediaAdvertInterflowApplyDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqMediaAdvertInterflowDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMediaAdvertInterflowDto;

import java.util.List;

/**
 * @author zhangmeng
 * @date 2018-11-07
 * @function 广告媒体互通远程接口服务
 */
@AdvancedFeignClient
public interface RemoteMediaAdvertInterflowService {

    /**
     * 媒体申请广告对应信息，广告将媒体对应的广告信息返回给媒体(此接口提供给媒体) 媒体控制2min发送一个app的请求
     * @param reqMediaAdvertInterflowDtos
     */
    void applyAdvertInfo(ReqMediaAdvertInterflowDto reqMediaAdvertInterflowDtos);

    /**
     * 更新申请下对应广告的状态，同时调用媒体接口将更新后的状态返回(此处需要调用媒体接口)
     * @param rspMediaAdvertInterflowDto
     */
    void updateApplyAdvertInfo(RspMediaAdvertInterflowDto rspMediaAdvertInterflowDto);

    /**
     * 通过配置id，获取定向配置
     * @param id
     * @return
     */
    AdvertOrientationPackageDto getAdvertOrientionPackageById(Long id);

    /**
     * 获取当前广告配置下的所有的限流媒体
     * @param advertId
     * @param orientPackageId
     * @return
     */
    List<AdvertLimitDto> getAdvertLimitList(Long advertId,Long orientPackageId);

    /**
     * 将当前媒体添加到配置的定向媒体中去
     * @param orientPackageIds
     * @param appId
     * @return
     */
    Boolean addAppToTargetApp(List<Long> orientPackageIds,Long appId);

    /**
     * 通过条件获取所有的申请
     * @param mediaAdvertInterflowApplyDto
     * @return
     */
    List<MediaAdvertApplyDetailDto> getApplyDetailByConditon(ReqMediaAdvertInterflowApplyDto mediaAdvertInterflowApplyDto);


    /**
     * 修复历史数据消耗，cpc，cvr不正确数据
     */
    Boolean fixHistoryDate(String curDate);

    /**
     * 修复媒体数据
     */
    Boolean fixHistoryDate2();


}