package cn.com.duiba.tuia.core.api.remoteservice.systemConfig;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.systemConfig.AdvertRepeatLunchConfigDto;


/**
 * 
 * ClassName: RemoteAdvertRepeatLunchConfigService <br/>
 * Function: 广告重复发券特殊资源发券间隔配置. <br/>
 * date: 2019年1月8日 下午2:24:00 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteAdvertRepeatLunchConfigService {

    /**
     * 
     * selectSpecialCongfigByType:(根据类型查询资源发券间隔配置). <br/>
     *
     * @author chencheng
     * @param sourceType
     * @return
     * @since JDK 1.8
     */
    List<AdvertRepeatLunchConfigDto> selectSpecialCongfigByType(Integer sourceType);
    
    /**
     * 
     * selectSpecialCongfigById:(根据资源id查询资源发券间隔配置). <br/>
     *
     * @author chencheng
     * @param sourceType
     * @return
     * @since JDK 1.8
     */
    AdvertRepeatLunchConfigDto selectSpecialCongfigById(Long id);
    
    /**
     * 
     * updateSpecialConfig:(修改资源发券间隔配置). <br/>
     *
     * @author chencheng
     * @param advertRepeatLunchConfigDO
     * @return
     * @since JDK 1.8
     */
    int updateSpecialConfig(AdvertRepeatLunchConfigDto advertRepeatLunchConfigDto);

}

