/**
 * 文件名： AdvertCheckRecordDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月11日 下午1:37:27
 */
package cn.com.duiba.tuia.core.api.dto;

/**
 * 广告审核记录表.
 *
 * @author: leiliang
 * @version:
 */
public class AdvertCheckRecordDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /** 审核通过. */
    public static final int   CHECK_PASS       = 1;

    /** 审核拒绝. */
    public static final int   CHECK_REFUSE     = 2;

    /** 广告ID. */
    private Long              advertId;

    /** 审核动作类型,1-审核通过;2-审核拒绝. */
    private Integer           checkType;

    /** 拒绝理由. */
    private String            reason;

    /** 广告顾问. */
    private String            checker;

    /** 广告顾问的联系方式. */
    private String            checkerContact;

    /**
     * Gets the advert id.
     *
     * @return the advertId
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advertId to set
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the check type.
     *
     * @return the checkType
     */
    public Integer getCheckType() {
        return checkType;
    }

    /**
     * Sets the check type.
     *
     * @param checkType the checkType to set
     */
    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    /**
     * Gets the reason.
     *
     * @return the reason
     */
    public String getReason() {
        return reason;
    }

    /**
     * Sets the reason.
     *
     * @param reason the reason to set
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * Gets the checker.
     *
     * @return the checker
     */
    public String getChecker() {
        return checker;
    }

    /**
     * Sets the checker.
     *
     * @param checker the checker to set
     */
    public void setChecker(String checker) {
        this.checker = checker;
    }

    /**
     * Gets the checker contact.
     *
     * @return the checkerContact
     */
    public String getCheckerContact() {
        return checkerContact;
    }

    /**
     * Sets the checker contact.
     *
     * @param checkerContact the checkerContact to set
     */
    public void setCheckerContact(String checkerContact) {
        this.checkerContact = checkerContact;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdvertCheckRecordDto [advertId=");
        builder.append(advertId);
        builder.append(", checkType=");
        builder.append(checkType);
        builder.append(", reason=");
        builder.append(reason);
        builder.append(", checker=");
        builder.append(checker);
        builder.append(", checkerContact=");
        builder.append(checkerContact);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
