/**
 * Project Name:manager-domain<br>
 * File Name:AdvertStatisticsData.java<br>
 * Package Name:cn.com.duiba.tuia.manager.model<br>
 * Date:2016年5月24日下午2:10:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.rsp.data;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.statistics.domain.AdvertStatisticsData;

/**
 * ClassName: AdvertTransformBaseData <br/>
 * Function: 广告转化数据基础信息. <br/>
 * date: 2018年4月19日 下午5:36:05 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class AdvertTransformBaseData extends AdvertStatisticsData {

    private static final long serialVersionUID = 3891823731372419168L;

    /** 安装APP的pv */
    private Long              installPv = 0L;

    /** 安装APP的uv */
    private Long              installUv = 0L;

    /** 启动APP的pv */
    private Long              startPv = 0L;

    /** 启动APP的uv */
    private Long              startUv = 0L;

    /** 注册的pv */
    private Long              registePv = 0L;

    /** 注册的uv */
    private Long              registeUv = 0L;

    /** 激活的pv */
    private Long              activatePv = 0L;

    /** 激活的uv */
    private Long              activateUv = 0L;

    /** 登录的pv */
    private Long              loginPv = 0L;

    /** 登录的uv */
    private Long              loginUv = 0L;

    /** 付费的pv */
    private Long              payPv = 0L;

    /** 付费的uv */
    private Long              payUv = 0L;
    
    /** 进件pv */
    private Long              entryPv = 0L;

    /** 进件uv */
    private Long              entryUv = 0L;

    /** 完件的pv */
    private Long              finishPv = 0L;

    /** 完件的uv */
    private Long              finishUv = 0L;

    /** 签收的Pv */
    private Long              signPv   = 0L;

    /** 签收的Uv */
    private Long              signUv   = 0L;

    /** 拒签的Pv */
    private Long              denyPv   = 0L;

    /** 拒签的Uv */
    private Long              denyUv   = 0L;

    /**
     * entryPv.
     *
     * @return the entryPv
     * @since JDK 1.8
     */
    public Long getEntryPv() {
        return entryPv;
    }

    /**
     * entryPv.
     *
     * @param entryPv the entryPv to set
     * @since JDK 1.8
     */
    public void setEntryPv(Long entryPv) {
        this.entryPv = entryPv;
    }

    /**
     * entryUv.
     *
     * @return the entryUv
     * @since JDK 1.8
     */
    public Long getEntryUv() {
        return entryUv;
    }

    /**
     * entryUv.
     *
     * @param entryUv the entryUv to set
     * @since JDK 1.8
     */
    public void setEntryUv(Long entryUv) {
        this.entryUv = entryUv;
    }

    /**
     * finishPv.
     *
     * @return the finishPv
     * @since JDK 1.8
     */
    public Long getFinishPv() {
        return finishPv;
    }

    /**
     * finishPv.
     *
     * @param finishPv the finishPv to set
     * @since JDK 1.8
     */
    public void setFinishPv(Long finishPv) {
        this.finishPv = finishPv;
    }

    /**
     * finishUv.
     *
     * @return the finishUv
     * @since JDK 1.8
     */
    public Long getFinishUv() {
        return finishUv;
    }

    /**
     * finishUv.
     *
     * @param finishUv the finishUv to set
     * @since JDK 1.8
     */
    public void setFinishUv(Long finishUv) {
        this.finishUv = finishUv;
    }

    /**
     * installPv.
     *
     * @return the installPv
     * @since JDK 1.8
     */
    public Long getInstallPv() {
        return installPv;
    }

    /**
     * installPv.
     *
     * @param installPv the installPv to set
     * @since JDK 1.8
     */
    public void setInstallPv(Long installPv) {
        this.installPv = installPv;
    }

    /**
     * installUv.
     *
     * @return the installUv
     * @since JDK 1.8
     */
    public Long getInstallUv() {
        return installUv;
    }

    /**
     * installUv.
     *
     * @param installUv the installUv to set
     * @since JDK 1.8
     */
    public void setInstallUv(Long installUv) {
        this.installUv = installUv;
    }

    /**
     * startPv.
     *
     * @return the startPv
     * @since JDK 1.8
     */
    public Long getStartPv() {
        return startPv;
    }

    /**
     * startPv.
     *
     * @param startPv the startPv to set
     * @since JDK 1.8
     */
    public void setStartPv(Long startPv) {
        this.startPv = startPv;
    }

    /**
     * startUv.
     *
     * @return the startUv
     * @since JDK 1.8
     */
    public Long getStartUv() {
        return startUv;
    }

    /**
     * startUv.
     *
     * @param startUv the startUv to set
     * @since JDK 1.8
     */
    public void setStartUv(Long startUv) {
        this.startUv = startUv;
    }

    /**
     * registePv.
     *
     * @return the registePv
     * @since JDK 1.8
     */
    public Long getRegistePv() {
        return registePv;
    }

    /**
     * registePv.
     *
     * @param registePv the registePv to set
     * @since JDK 1.8
     */
    public void setRegistePv(Long registePv) {
        this.registePv = registePv;
    }

    /**
     * registeUv.
     *
     * @return the registeUv
     * @since JDK 1.8
     */
    public Long getRegisteUv() {
        return registeUv;
    }

    /**
     * registeUv.
     *
     * @param registeUv the registeUv to set
     * @since JDK 1.8
     */
    public void setRegisteUv(Long registeUv) {
        this.registeUv = registeUv;
    }

    /**
     * activatePv.
     *
     * @return the activatePv
     * @since JDK 1.8
     */
    public Long getActivatePv() {
        return activatePv;
    }

    /**
     * activatePv.
     *
     * @param activatePv the activatePv to set
     * @since JDK 1.8
     */
    public void setActivatePv(Long activatePv) {
        this.activatePv = activatePv;
    }

    /**
     * activateUv.
     *
     * @return the activateUv
     * @since JDK 1.8
     */
    public Long getActivateUv() {
        return activateUv;
    }

    /**
     * activateUv.
     *
     * @param activateUv the activateUv to set
     * @since JDK 1.8
     */
    public void setActivateUv(Long activateUv) {
        this.activateUv = activateUv;
    }

    /**
     * loginPv.
     *
     * @return the loginPv
     * @since JDK 1.8
     */
    public Long getLoginPv() {
        return loginPv;
    }

    /**
     * loginPv.
     *
     * @param loginPv the loginPv to set
     * @since JDK 1.8
     */
    public void setLoginPv(Long loginPv) {
        this.loginPv = loginPv;
    }

    /**
     * loginUv.
     *
     * @return the loginUv
     * @since JDK 1.8
     */
    public Long getLoginUv() {
        return loginUv;
    }

    /**
     * loginUv.
     *
     * @param loginUv the loginUv to set
     * @since JDK 1.8
     */
    public void setLoginUv(Long loginUv) {
        this.loginUv = loginUv;
    }

    /**
     * payPv.
     *
     * @return the payPv
     * @since JDK 1.8
     */
    public Long getPayPv() {
        return payPv;
    }

    /**
     * payPv.
     *
     * @param payPv the payPv to set
     * @since JDK 1.8
     */
    public void setPayPv(Long payPv) {
        this.payPv = payPv;
    }

    /**
     * payUv.
     *
     * @return the payUv
     * @since JDK 1.8
     */
    public Long getPayUv() {
        return payUv;
    }

    /**
     * payUv.
     *
     * @param payUv the payUv to set
     * @since JDK 1.8
     */
    public void setPayUv(Long payUv) {
        this.payUv = payUv;
    }

    public Long getSignPv() {
        return signPv;
    }

    public void setSignPv(Long signPv) {
        this.signPv = signPv;
    }

    public Long getSignUv() {
        return signUv;
    }

    public void setSignUv(Long signUv) {
        this.signUv = signUv;
    }

    public Long getDenyPv() {
        return denyPv;
    }

    public void setDenyPv(Long denyPv) {
        this.denyPv = denyPv;
    }

    public Long getDenyUv() {
        return denyUv;
    }

    public void setDenyUv(Long denyUv) {
        this.denyUv = denyUv;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
