package cn.com.duiba.tuia.core.api.enums.advert;

import java.util.stream.Stream;

/**
 * 考核指标类型枚举
 *
 * @author chensong
 * @create 2018-10-16
 */
public enum AssessTypeEnum {


    REQUEST_FORM(1, "REQUEST_FORM", "申请/填表"),

    PAYMENT(2, "PAYMENT", "付费"),

    DELIVERY(3, "DELIVERY", "发货"),

    SIGN(4, "SIGN", "签收"),

    INSTALLATION(5, "INSTALLATION", "安装"),

    ACTIVATION(6, "ACTIVATION", "激活"),

    REGISTRATION(7, "REGISTRATION", "注册"),

    LOGIN(8, "LOGIN", "登陆/次日登入/7日登陆"),

    INCOMING(9, "INCOMING", "进件"),

    FINISH(10, "FINISH", "完件"),

    GRANT_CREDIT(11, "GRANT_CREDIT", "授信"),

    LENDERS(12, "LENDERS", "放款"),

    ROI(13, "ROI", "ROI"),

    OTHER(14, "OTHER", "其他")

    ;

    private int num;

    private String code;

    private String desc;

    AssessTypeEnum(int num, String code, String desc){
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据数值标识获取考核指标类型枚举
     *
     * @param num
     * @return
     */
    public static AssessTypeEnum getByNum(Integer num){
        if (num == null) {
            return null;
        }
        return Stream.of(AssessTypeEnum.values()).filter(e -> e.getNum() == num).findFirst().orElse(null);
    }




}
