package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertTradePackageDto;

import java.util.List;

/**
 * @author zhangmeng
 * @date 2018/12/2
 * @function
 */
@AdvancedFeignClient
public interface RemoteAdvertTradePackageService {

    /**
     * 查询所有有效的人群定向行业人群包标签
     * @return
     */
    List<AdvertTradePackageDto> queryTradePackageTag();

    /**
     * 保存行业人群定向包行业人群包标签（新增和修改后的保存）如果有标签值或这value存在则不允许插入或者修改
     * @param advertTradePackageDto
     * @return id
     */
     Long saveTradePackageTag(AdvertTradePackageDto advertTradePackageDto);


    /**
     * 删除指定的人群定向包行业人群包标签(需要校验当前标签是否存在被配置引用，引用则提示不允许删除)
     * @param id
     * @return
     */
    int deleteTradePackageTag(Long id);

    /**
     * 校验行业人群包标签是否已经存在
     * @return
     */
    Boolean checkTagIsExisted(AdvertTradePackageDto advertTradePackageDto);

    /**
     * 校验行业人群包标签是否被配置引用
     * @return
     */
    Boolean checkTagIsUsed(String tagVlaue);
}
