/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertPlanDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年8月31日下午3:27:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * ClassName: AdvertPlanDto <br/>
 * Function: 广告计划. <br/>
 * date: 2016年8月31日 下午3:27:36 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class AdvertPlanDto implements Serializable {

    private static final long         serialVersionUID = 1L;

    /** 广告ID. */
    private Long                      id;

    //广告类型
    private Integer advertType;

    /** 广告主ID. */
    private Long                      accountId;

    /** 名称. */
    private String                    name;

    /** 计费方式. */
    private Integer                   chargeType;

    /** 广告出价(分). */
    private Long                      fee;

    /** 每日预算. */
    private Long                      budgetPerDay;

    /** 投放平台. */
    private List<String>              platform;

    /** 生效期. */
    private Date                      startDate;

    /** 失效期. */
    private Date                      endDate;

    /** 投放时段列表. */
    private List<AdvertPlanPeriodDto> periods;

    /** 投放Id列表. */
    private String                    regionIds;

    /** 审核状态. */
    private Integer                   checkStatus;

    /** 启用状态. */
    private Integer                   enableStatus;

    /** 有效状态. */
    private Integer                   validStatus;

    /** 是否审核通过过. */
    private boolean                   isCheckPass;

    /** 优惠券ID. */
    private Long                      duibaId;

    public Long getDuibaId() {
        return duibaId;
    }

    public void setDuibaId(Long duibaId) {
        this.duibaId = duibaId;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public boolean isCheckPass() {
        return isCheckPass;
    }

    public void setCheckPass(boolean isCheckPass) {
        this.isCheckPass = isCheckPass;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    public List<String> getPlatform() {
        return platform;
    }

    public void setPlatform(List<String> platform) {
        this.platform = platform;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<AdvertPlanPeriodDto> getPeriods() {
        return periods;
    }

    public void setPeriods(List<AdvertPlanPeriodDto> periods) {
        this.periods = periods;
    }

    public String getRegionIds() {
        return regionIds;
    }

    public void setRegionIds(String regionIds) {
        this.regionIds = regionIds;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdvertPlanDto [id=");
        builder.append(id);
        builder.append(", accountId=");
        builder.append(accountId);
        builder.append(", name=");
        builder.append(name);
        builder.append(", chargeType=");
        builder.append(chargeType);
        builder.append(", fee=");
        builder.append(fee);
        builder.append(", budgetPerDay=");
        builder.append(budgetPerDay);
        builder.append(", platform=");
        builder.append(platform);
        builder.append(", startDate=");
        builder.append(startDate);
        builder.append(", endDate=");
        builder.append(endDate);
        builder.append(", periods=");
        builder.append(periods);
        builder.append(", regionIds=");
        builder.append(regionIds);
        builder.append(", checkStatus=");
        builder.append(checkStatus);
        builder.append(", enableStatus=");
        builder.append(enableStatus);
        builder.append(", validStatus=");
        builder.append(validStatus);
        builder.append(", isCheckPass=");
        builder.append(isCheckPass);
        builder.append(", duibaId=");
        builder.append(duibaId);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
