/**
 * 文件名： AdvertStatisticsDay.java 此类描述的是： 作者:leiliang 创建时间: 2016年4月19日 下午2:59:05
 */
package cn.com.duiba.tuia.core.api.dto;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告消费信息.
 *
 * @author: leiliang
 * @version:
 */
public class AdvertStatisticsDayDto extends BaseDto {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -599228665666694323L;

    /** 广告主ID. */
    private Long              accountId;

    /** 广告ID. */
    private Long              advertId;

    /** 应用ID. */
    private Long              appId;

    /** 每日发券量. */
    private Long              launchCount;

    /** 每日曝光数. */
    private Long              exposureCount;

    /** 每日点击数. */
    private Long              clickCount;

    /** 每日有效点击数. */
    private Long              efClickCount;

    /** 每日消费(分). */
    private Long              consumeTotal;

    /** 当前日期. */
    private Date              curDate;

    /** 兑换券ID. */
    private Long              duibaItemId;

    /** 计费次数. */
    private Long              billingCount;

    /** 点击UV. */
    private Long              clickUv;

    /** 统计时间. */
    private int               time;

    /** The is settlement. */
    private Integer           isSettlement;

    /** The billing price. */
    private Long              billingPrice;

    /**
     * Gets the account id.
     *
     * @return the account id
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * Sets the account id.
     *
     * @param accountId the account id
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the launch count.
     *
     * @return the launch count
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * Sets the launch count.
     *
     * @param launchCount the launch count
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * Gets the exposure count.
     *
     * @return the exposure count
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * Sets the exposure count.
     *
     * @param exposureCount the exposure count
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * Gets the click count.
     *
     * @return the click count
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * Sets the click count.
     *
     * @param clickCount the click count
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * Gets the ef click count.
     *
     * @return the ef click count
     */
    public Long getEfClickCount() {
        return efClickCount;
    }

    /**
     * Sets the ef click count.
     *
     * @param efClickCount the ef click count
     */
    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * Gets the consume total.
     *
     * @return the consume total
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * Sets the consume total.
     *
     * @param consumeTotal the consume total
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * Gets the cur date.
     *
     * @return the cur date
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * Sets the cur date.
     *
     * @param curDate the cur date
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * Gets the duiba item id.
     *
     * @return the duiba item id
     */
    public Long getDuibaItemId() {
        return duibaItemId;
    }

    /**
     * Sets the duiba item id.
     *
     * @param duibaItemId the duiba item id
     */
    public void setDuibaItemId(Long duibaItemId) {
        this.duibaItemId = duibaItemId;
    }

    /**
     * Gets the billing count.
     *
     * @return the billing count
     */
    public Long getBillingCount() {
        return billingCount;
    }

    /**
     * Sets the billing count.
     *
     * @param billingCount the billing count
     */
    public void setBillingCount(Long billingCount) {
        this.billingCount = billingCount;
    }

    /**
     * Gets the click uv.
     *
     * @return the click uv
     */
    public Long getClickUv() {
        return clickUv;
    }

    /**
     * Sets the click uv.
     *
     * @param clickUv the click uv
     */
    public void setClickUv(Long clickUv) {
        this.clickUv = clickUv;
    }

    /**
     * Gets the time.
     *
     * @return the time
     */
    public int getTime() {
        return time;
    }

    /**
     * Sets the time.
     *
     * @param time the time
     */
    public void setTime(int time) {
        this.time = time;
    }

    /**
     * Gets the is settlement.
     *
     * @return the checks if is settlement
     */
    public Integer getIsSettlement() {
        return isSettlement;
    }

    /**
     * Sets the is settlement.
     *
     * @param isSettlement the checks if is settlement
     */
    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

    public Long getBillingPrice() {
        return billingPrice;
    }

    public void setBillingPrice(Long billingPrice) {
        this.billingPrice = billingPrice;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
