package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.core.api.dto.AdvertOrientationPackageDto;
import cn.com.duiba.tuia.core.api.dto.req.solt.ReqAppSlotDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertChargeDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertOrientationPackageBudgetPerDayDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertTargetAppDetail;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteAdvertOrientPackageBackendService {

	/**
	 * 根据广告ID查询定向投放配置包
	 * @param advertId 广告ID
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<AdvertOrientationPackageDto>> getAdvertOrientationPackage(Long advertId);

	/**
	 * 获取扶持广告对应的优质媒体
	 *
	 * @param advertId 扶持广告ID
	 * @return
	 */
	List<RspAdvertTargetAppDetail> getAdvertGoodAppList(Long advertId);

	/**
	 * 判断是否可以开启新广告扶持
	 *
	 * @param advertId      广告ID
	 * @param orientationId 配置包ID
	 * @return true-可以开启广告扶持，false-不能
	 */
	Boolean canBeOpenAdvertSupport(Long advertId, Long orientationId) throws BizException;

	/**
	 * 新增或者复制定向配置包
	 * @param dto 返回定向配置包的自增ID
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Long> addAvertOrientationPackage(AdvertOrientationPackageDto dto);
	
	/**
	 * 根据定向包ID更新定向包的启用状态
	 * @param enableStatus
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateAdvertOrientPackageEnableStatus(Integer enableStatus, Long id,Long bugetPerDay);
	
	/**
	 * 保存对定向配置包的修改
	 * @param dto
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Boolean> updateAdvertOrientPackage(AdvertOrientationPackageDto dto,List<ReqAppSlotDto> reqAppSlotDtos);
	
	/**
     * 广告单价查询
     * advertOrientPackageId若为null,则根据advertId查询,不为null,两者组合查
     * @param advertId 广告ID
     * @param advertOrientPackageId 配置包ID
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getFeeByAdvertId(Long advertId, Long advertOrientPackageId);

	/**
	 * 广告单价查询
	 * advertOrientPackageId若为null,则根据advertId查询,不为null,两者组合查
	 * @param advertIds 广告ID
	 * @return
	 */
	DubboResult<Map<Long,Long>> getFeeByAdvertIds(List<Long> advertIds);

	/**
	 * 点击单价和转化出价查询
	 * advertOrientPackageId若为null,则根据advertId查询,不为null,两者组合查
	 * @param advertId 广告ID
	 * @param advertOrientPackageId 配置包ID
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<RspAdvertChargeDto>> getFeeAndCpaFeeByAdvertId(Long advertId, Long advertOrientPackageId);
	
	/**
	 * 根据广告ID查询默认定向包信息
	 * @param advertId
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<AdvertOrientationPackageDto> selectDefaultByAdvertId(Long advertId);
	
	/**
	 * 修改定向配置名称
	 *
	 * @param packageName 定向配置名称
	 * @param id 定向配置id
	 * @author chencheng
	 * @return
	 */
	DubboResult<Integer> updateAdvertOrientPackageName(String packageName, Long id);
	
	/**
	 * 修改定向配置每日预算
	 *
	 * @param id 定向配置id
	 * @author chencheng
	 * @return
	 */
	DubboResult<Integer> updateAdvertOrientPackageBudget(Long budgetPerDay, Long id);
	
	/**
     * 根据广告ID查询定向配置包每日预算
     * @param advertId 广告ID
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<RspAdvertOrientationPackageBudgetPerDayDto>> getAdvertOrientationPackageBudget(Long advertId);
    
    /**
     * 根据定向配置ID查询定向投放配置
     * @param advertOrientPackageId 定向配置ID
     * @return
     * @since JDK 1.6
     */
    DubboResult<AdvertOrientationPackageDto> selectById(Long advertOrientPackageId);

	/**
	 * 根据广告ID批量查询定向信息
	 * @param advertIds
	 * @return
	 */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="20000")
	DubboResult<List<AdvertOrientationPackageDto>> listAdvertOrientationPackageByAdvertIds(List<Long> advertIds);

	List<AdvertOrientationPackageDto> queryOrientationPkgByAdvertIds(List<Long> advertIds);

	/**
	 * 
	 * batchUpdate:(批量更新定向配置). <br/>
	 *
	 * @author chencheng
	 * @param list
	 * @return
	 * @since JDK 1.8
	 */
	Boolean batchUpdateOrientationPackage(List<AdvertOrientationPackageDto> list);

	/**
	 * 是否超出最低 --- 只针对兑吧广告主有效
	 * @param accountId
	 * @param price
	 * @param chargeType
	 * @return
	 */
    boolean isOverBottomPrice(Long accountId,Long price,Integer chargeType);

	/**
	 * 通过广告下面的配置包列表
	 *
	 * @param advertId 广告id
	 * @return 配置包列表，不包含组装数据，只是advert_orientation_package中存在的数据
	 */
	List<AdvertOrientationPackageDto> selectOrientPkgListByAdvertId(Long advertId);

	/**
	 * 判断是否可以删除限流媒体，媒体下存在高危广告位时不可删除
	 *
	 * @param appId 限流媒体ID
	 * @param orientationPkgId 配置包ID
	 * @return true：可以删除，false：不能删除
	 */
	Boolean isDeleteLimitFlowApp(Long appId, Long orientationPkgId);

	/**
	 * 不在提醒推荐该app
	 * @param advertId 广告id
	 * @param orientPkgId 配置包id
	 * @param appId 媒体id
	 * @param type 推荐类型 1-定向 2-限流
	 */
	Boolean notNoticeRecommend(Long advertId, Long orientPkgId, Long appId, Integer type);

}
