package cn.com.duiba.tuia.core.api.remoteservice.slot;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.solt.ReqAppSlotDto;
import cn.com.duiba.tuia.core.api.dto.req.solt.SlotInfoCenterReq;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAppSlotDto;

import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2018年03月06日 15:20
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteAppSlotService {

    /**
     * 批量新增定向配置的广告位数据
     *
     * @param orientationId
     * @param advertId
     * @param reqAppSlotDtoList
     */
    void addAppOrientationSlot(Long orientationId, Long advertId, List<ReqAppSlotDto> reqAppSlotDtoList);


    void addAppPackageSlot(Long appId, Long packageId, List<Long> slotIds);

    List<RspAppSlotDto> getPackageSlots(Long appId, Long packageId);

    List<RspAppSlotDto> getOrientationSlots(Long appId, Long orientationId, Integer bindType);

    /**
     * 转换屏蔽标签为名称
     * @param slotInfoReq
     * @param slotInfoReqList
     * @return
     */
    String getShieldContent(SlotInfoCenterReq slotInfoReq, List<SlotInfoCenterReq> slotInfoReqList);
}
