/**
 * 文件名： AdvertiserDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月1日 下午1:36:56
 */
package cn.com.duiba.tuia.core.api.dto;

import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author: leiliang
 * @version:
 */
public class AccountDto extends BaseDto {

    private static final long serialVersionUID        = 4476874317666316204L;

    /** 邮箱未验证. */
    public static final int   EMAIL_STATUS_UNCHECK    = 0;

    /** 邮箱已验证. */
    public static final int   EMAIL_STATUS_CHECKED    = 1;

    /** 未冻结. */
    public static final int   UNFREEZED_STATUS        = 0;

    /** 已冻结. */
    public static final int   FREEZED_STATUS          = 1;

    /** 审核中. */
    public static final int   CHECK_STATUS_ING        = 0;

    /** 审核通过. */
    public static final int   CHECK_STATUS_PASS       = 1;

    /** 审核拒绝. */
    public static final int   CHECK_STATUS_REFUSE     = 2;

    /** 用户类型：0：广告主. */
    public static final int   USER_TYPE_OF_ADVERTISER = 0;
    
    /** 用户类型：代理商. */
    public static final int   USER_TYPE_AGENT         = 2;
    
    private static final String SPLITSYMBOL = ".";
    
    /** 代理商最大层级是4级，accountLevel为3. */
    public static final int   MAX_AGENT_LEVEL         = 3;
    
    /** 广告主最大层级是5级，accountLevel为4. */
    public static final int   MAX_ADVERTISER_LEVEL    = 4;
    
    /** 邮箱. */
    private String            email;

    /** 密码. */
    private String            password;

    /** 公司名称. */
    private String            companyName;

    /** 冻结状态:0：未冻结;1：冻结. */
    private Integer           freezeStatus;

    /** 邮箱状态:0：未验证;1：已验证. */
    private Integer           emailStatus;

    /** 审核状态:0：审核中;1：审核通过;2：审核拒绝. */
    private Integer           checkStatus;

    /** 营业执照号. */
    private String            businessLicenseId;

    /** 营业执照名称. */
    private String            businessLicenseName;

    /** 营业执照照片. */
    private String            businessLicenseUrl;

    /** 公司地址. */
    private String            companyAddress;

    /** 联系人姓名. */
    private String            linkman;

    /** 联系人手机号. */
    private String            linkmanPhone;

    /** 联系人QQ. */
    private String            linkmanQQ;

    /** 用户类型. */
    private Integer           userType;

    /** 代理商ID. */
    private Long              agentId;

    /** 代理商公司名. */
    private String            agentCompanyName;

    /** 角色id. */
    private Long              roleId;

    /** 谷歌验证器秘钥. */
    private String            googleAuthKey;

    /** 操作员名. */
    private String            operatorName;

    /** 账户来源：0：兑吧；1-推啊 */
    private Integer           accountSource;

    //账号所属公司，1-杭州推啊，2-霍尔果斯推啊
    private Integer companyOwner;

    //当前的主体状态，1-杭州推啊，2-签约了霍尔果斯，生效的余额是杭州推啊，3-签约了霍尔果斯，生效的余额是霍尔果斯
    private Integer currentMainStatus;

    //是否签约了多个主体的状态，0-否，1-是
    private Integer multipleMainStatus;

    /** 代理商(广告主)等级 0为最顶级 */
    private Integer           accountLevel;

    /** 上级代理商层级连接，点分隔 */
    private String            accountLevelNum;

    private String auditor;

    private Date auditTime;

    private Date editTime;

    //收件邮箱
    private String receivingMailbox;

    /**
     * accountLevel.
     *
     * @return the accountLevel
     * @since JDK 1.8
     */
    public Integer getAccountLevel() {
        return accountLevel;
    }

    /**
     * accountLevel.
     *
     * @param accountLevel the accountLevel to set
     * @since JDK 1.8
     */
    public void setAccountLevel(Integer accountLevel) {
        this.accountLevel = accountLevel;
    }

    /**
     * accountLevelNum.
     *
     * @return the accountLevelNum
     * @since JDK 1.8
     */
    public String getAccountLevelNum() {
        return accountLevelNum;
    }

    /**
     * accountLevelNum.
     *
     * @param accountLevelNum the accountLevelNum to set
     * @since JDK 1.8
     */
    public void setAccountLevelNum(String accountLevelNum) {
        this.accountLevelNum = accountLevelNum;
    }

    public Integer getMultipleMainStatus() {
        return multipleMainStatus;
    }

    public void setMultipleMainStatus(Integer multipleMainStatus) {
        this.multipleMainStatus = multipleMainStatus;
    }

    public Integer getCompanyOwner() {
        return companyOwner;
    }

    public void setCompanyOwner(Integer companyOwner) {
        this.companyOwner = companyOwner;
    }

    public Integer getCurrentMainStatus() {
        return currentMainStatus;
    }

    public void setCurrentMainStatus(Integer currentMainStatus) {
        this.currentMainStatus = currentMainStatus;
    }

    /**
     * accountSource.
     *
     * @return  the accountSource
     * @since   JDK 1.8
     */
    public Integer getAccountSource() {
        return accountSource;
    }
    
    /**
     * accountSource.
     *
     * @param   accountSource    the accountSource to set
     * @since   JDK 1.8
     */
    public void setAccountSource(Integer accountSource) {
        this.accountSource = accountSource;
    }

    public String getGoogleAuthKey() {
        return googleAuthKey;
    }

    public void setGoogleAuthKey(String googleAuthKey) {
        this.googleAuthKey = googleAuthKey;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    public Integer getEmailStatus() {
        return emailStatus;
    }

    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getBusinessLicenseId() {
        return businessLicenseId;
    }

    public void setBusinessLicenseId(String businessLicenseId) {
        this.businessLicenseId = businessLicenseId;
    }

    public String getBusinessLicenseName() {
        return businessLicenseName;
    }

    public void setBusinessLicenseName(String businessLicenseName) {
        this.businessLicenseName = businessLicenseName;
    }

    public String getBusinessLicenseUrl() {
        return businessLicenseUrl;
    }

    public void setBusinessLicenseUrl(String businessLicenseUrl) {
        this.businessLicenseUrl = businessLicenseUrl;
    }

    public String getCompanyAddress() {
        return companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    public String getLinkmanQQ() {
        return linkmanQQ;
    }

    public void setLinkmanQQ(String linkmanQQ) {
        this.linkmanQQ = linkmanQQ;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Date getEditTime() {
        return editTime;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }
    public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	/**
	 * 
	 * getAccountTheLevelNum:(获取当前的代理商层级，算上本级id). <br/>
	 *
	 * @author chencheng
	 * @return
	 * @since JDK 1.8
	 */
	public String getTheLevelNum(){
	    if(this.accountLevel == null){
	        return StringUtils.EMPTY;
	    }
	    if(this.accountLevel == 0){
            return super.id+"";
        }
	    return new StringBuilder(this.accountLevelNum).append(SPLITSYMBOL).append(super.id).toString();
	}
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getReceivingMailbox() {
        return receivingMailbox;
    }

    public void setReceivingMailbox(String receivingMailbox) {
        this.receivingMailbox = receivingMailbox;
    }
}
