package cn.com.duiba.tuia.core.api.dto;

import cn.com.duiba.tuia.core.api.dto.req.solt.ReqAppSlotDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertTargetAppDetail;
import cn.com.duiba.tuia.core.api.dto.rsp.app.AppPackageDto;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;
import java.util.List;
import java.util.Optional;

public class AdvertOrientationPackageDto extends BaseDto {

    /** 非默认定向包 */
    public static final int           NOTISDEFAULT     = 0;
    /** 默认定向包 */
    public static final int           DEFAULT_PACKAGE  = 1;
    public static final int           ISENABLE         = 1;
    public static final String        DEFAULT_NAME     = "默认";
    private static final long         serialVersionUID = -4515037621723222896L;
    
    //预算平滑消耗模式：0-加速消耗
    public static final int BUDGET_SMOOTH_DEFULT = 0;

    /** 广告主键 */
    private Long                      advertId;

    /** 定向包名称 */
    private String                    packageName;

    /** 计费方式 */
    private Integer                   chargeType;

    /** 广告出价.1：CPC;2：CPA */
    private Long                      fee;

    /** 转化出价(分). */
    private Long                      cpaFee;

    /** 操作系统 */
    private String                    platform;

    /** 投放区域 */
    private String                    regionIds;

    /** 启用状态:1-启用;0-暂停 */
    private Integer                   enableStatus;

    /** 设备价值 */
    private String                    phoneLevel;

    /** 定向投放次数(发券顺序) */
    private String                    directionalNum;

    /** 定向媒体限制类型 packageType=1时,该值一定为1,自动模式为2,优投模式为3 */
    private Integer targetAppLimit;

    /** 新广告扶持 true-扶持 false-不扶持 */
    private Boolean supportStatus;

    private Date supportTime;

    private Date supportEndTime;

    /**
     * 是否是默认值：0 否 1 是
     */
    private Integer                   isDefault;

    /**
     * 网络类型：1、WIFI；2、3G；3、4G；4、其他
     */
    private String                    networkType;

    /**
     * 运营商：1、移动；2、联通；3、电信；4、其他
     */
    private String                    operators;

    /**
     * 年龄区间
     */
    private String                    ageRegion;

    /**
     * 性别：1 男 2 女
     */
    private String                    sex;

    /**
     * 工作状态：0不限 1:学生 2:工作者 3:其它
     */
    private String                    workState;

    //投放目标类型，1-消耗优先、2-成本优先、3-均衡投放、4-人工定向、0-CPC的
    private Integer putTargetType;

    /** 投放时段 */
    private List<AdvertPlanPeriodDto> periods;
    /** 广告屏蔽标签 */

    private String                         bannedTagNums;
    /** 定向媒体列表详情 */

    private List<RspAdvertTargetAppDetail> targetApp;

    /** 建议定向的媒体 */
    private List<RspAdvertTargetAppDetail> recommendTargetApp;

    /** 定向媒体appId */
    private String                         targetAppIds;
    /** 限流媒体 */
    private List<AdvertLimitDto>           advertLimit;

    /**
     * 由系统自动限流的 媒体
     */
    private List<AdvertLimitDto>           advertAutoLimit;

    /** 建议屏蔽的媒体 */
    private List<AdvertLimitDto>           recommendLimitApp;

    //限流媒体流量包的媒体列表
    private List<AdvertLimitDto>           limitFlowAppList;

    //限流媒体流量包列表
    private List<AppPackageDto>           limitFlowPackageList;

    //限流媒体流量包ID列表
    private List<Long>                limitFlowAppPackageIds;

    /** 每日预算. */
    private Long                           budgetPerDay;

    /** 保存屏蔽前每日预算*/
    private Long                     tempBudgetPerDay;
    /** 限流媒体 */
    private String                         limitAppIds;

    //包的类型 1-人工生成的包 2-系统托管的包
    private Integer packageType;

    //活动类型：1-插件工具、2-活动工具、3-直投页、-1-不限
    private String activityType;

    //是否删除，1-删除 0-不删除
    private Integer isDeleted;
    
    /** 屏蔽流量类型：1.1:微信-android,1.2:微信-ios;2.1:QQ-android,2.2:QQ-ios;3.1:支付宝-android,3.2:支付宝-ios */
    private String bannedAppFlowType;

    /** 定向流量类型：1:微信;2:QQ;3:支付宝;4:其他 */
    private String appFlowType;

    //手机品牌
    private String brandName;

    /** 广告行业接受度：空-不限，0-其他，2-喜欢，1-接受，3-无感，4-排斥 */
    private String                         tradeAccept;

    /** 兴趣点人群:空-不限，shopping-网购，finance-金融理财， health-健康养生，poker-棋牌游戏，biggame-大型游戏 */
    private String                         crowdInterest;

    /**
     * 广告位
     */
    private List<ReqAppSlotDto>       appSlotReqList;

    /**
     * 同步地域到所有配置
     */
    private Boolean regionIdsConfiguredToAll;

    //屏蔽流量：是否考虑落地页标签 是否是app安装   0：不考虑，1:考虑，2：取消考虑
    private Integer           isAppInstall;

    /**
     * 被全局流量命中的字段的值
     */
    private String hitValue;

    /**
     * 是否被全局流量命中
     */
    private Integer hitStatus;

    //是否开启自动托管,1-是、0-否
    private Integer trusteeship;

    /**
     * subtype 已经选择的调整因子
     */
    private Integer subtype;

    /**
     * 调整因子对应的 成本
     */
    private Long adjustCost;

    /**
     * 投放类型，0-互动广告类型，1-活动直投落地页
     */
    private Integer pkgPutType;

    /**
     * 人群定向包标签列表
     */
    private String crowdTradePackageTag;
   

    /**
     * 素材列表
     */
    private String materialIds;
    
    /** 消耗速度，0：加速投放，1：匀速投放 */
    private Integer                        budgetSmooth;

    /**
     * budgetSmooth.
     *
     * @return the budgetSmooth
     * @since JDK 1.8
     */
    public Integer getBudgetSmooth() {
        return budgetSmooth;
    }

    /**
     * budgetSmooth.
     *
     * @param budgetSmooth the budgetSmooth to set
     * @since JDK 1.8
     */
    public void setBudgetSmooth(Integer budgetSmooth) {
        this.budgetSmooth = budgetSmooth;
    }

    /**
     * pkgPutType.
     *
     * @return the pkgPutType
     * @since JDK 1.8
     */
    public Integer getPkgPutType() {
        return pkgPutType;
    }

    /**
     * pkgPutType.
     *
     * @param pkgPutType the pkgPutType to set
     * @since JDK 1.8
     */
    public void setPkgPutType(Integer pkgPutType) {
        this.pkgPutType = pkgPutType;
    }

    // 智能采买
    private Integer autoMatch;

    public Integer getAutoMatch() {
        return autoMatch;
    }

    public void setAutoMatch(Integer autoMatch) {
        this.autoMatch = autoMatch;
    }

    public List<AdvertLimitDto> getAdvertAutoLimit() {
        return advertAutoLimit;
    }

    public void setAdvertAutoLimit(List<AdvertLimitDto> advertAutoLimit) {
        this.advertAutoLimit = advertAutoLimit;
    }

    public Integer getSubtype() {
        return subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public Long getAdjustCost() {
        return adjustCost;
    }

    public void setAdjustCost(Long adjustCost) {
        this.adjustCost = adjustCost;
    }

    public Integer getTrusteeship() {
        return trusteeship;
    }

    public void setTrusteeship(Integer trusteeship) {
        this.trusteeship = trusteeship;
    }

    public Date getSupportTime() {
        return supportTime;
    }

    public void setSupportTime(Date supportTime) {
        this.supportTime = supportTime;
    }

    public List<RspAdvertTargetAppDetail> getRecommendTargetApp() {
        return recommendTargetApp;
    }

    public void setRecommendTargetApp(List<RspAdvertTargetAppDetail> recommendTargetApp) {
        this.recommendTargetApp = recommendTargetApp;
    }

    public List<AdvertLimitDto> getRecommendLimitApp() {
        return recommendLimitApp;
    }

    public void setRecommendLimitApp(List<AdvertLimitDto> recommendLimitApp) {
        this.recommendLimitApp = recommendLimitApp;
    }

    public Integer getPutTargetType() {
        return putTargetType;
    }

    public void setPutTargetType(Integer putTargetType) {
        this.putTargetType = putTargetType;
    }

    public Integer getTargetAppLimit() {
        return targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public Boolean getSupportStatus() {
        return Optional.ofNullable(supportStatus).orElse(false);
    }

    public void setSupportStatus(Boolean supportStatus) {
        this.supportStatus = supportStatus;
    }

    public Long getTempBudgetPerDay() {
        return tempBudgetPerDay;
    }

    public void setTempBudgetPerDay(Long tempBudgetPerDay) {
        this.tempBudgetPerDay = tempBudgetPerDay;
    }

    public String getHitValue() {
        return hitValue;
    }

    public void setHitValue(String hitValue) {
        this.hitValue = hitValue;
    }

    public Integer getHitStatus() {
        return hitStatus;
    }

    public void setHitStatus(Integer hitStatus) {
        this.hitStatus = hitStatus;
    }

    public String getWorkState() {
        return workState;
    }

    public void setWorkState(String workState) {
        this.workState = workState;
    }

    public Integer getIsAppInstall() {
        return isAppInstall;
    }

    public void setIsAppInstall(Integer isAppInstall) {
        this.isAppInstall = isAppInstall;
    }

    public List<ReqAppSlotDto> getAppSlotReqList() {
        return appSlotReqList;
    }

    public void setAppSlotReqList(List<ReqAppSlotDto> appSlotReqList) {
        this.appSlotReqList = appSlotReqList;
    }

    public Boolean getRegionIdsConfiguredToAll() {
        return regionIdsConfiguredToAll;
    }

    public void setRegionIdsConfiguredToAll(Boolean regionIdsConfiguredToAll) {
        this.regionIdsConfiguredToAll = regionIdsConfiguredToAll;
    }

    /**
     * tradeAccept.
     *
     * @return the tradeAccept
     * @since JDK 1.8
     */
    public String getTradeAccept() {
        return tradeAccept;
    }

    /**
     * tradeAccept.
     *
     * @param tradeAccept the tradeAccept to set
     * @since JDK 1.8
     */
    public void setTradeAccept(String tradeAccept) {
        this.tradeAccept = tradeAccept;
    }

    /**
     * crowdInterest.
     *
     * @return the crowdInterest
     * @since JDK 1.8
     */
    public String getCrowdInterest() {
        return crowdInterest;
    }

    /**
     * crowdInterest.
     *
     * @param crowdInterest the crowdInterest to set
     * @since JDK 1.8
     */
    public void setCrowdInterest(String crowdInterest) {
        this.crowdInterest = crowdInterest;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    
    /**
     * bannedAppFlowType.
     *
     * @return  the bannedAppFlowType
     * @since   JDK 1.8
     */
    public String getBannedAppFlowType() {
        return bannedAppFlowType;
    }
    
    /**
     * bannedAppFlowType.
     *
     * @param   bannedAppFlowType    the bannedAppFlowType to set
     * @since   JDK 1.8
     */
    public void setBannedAppFlowType(String bannedAppFlowType) {
        this.bannedAppFlowType = bannedAppFlowType;
    }

    /**
     * appFlowType.
     *
     * @return  the appFlowType
     * @since   JDK 1.8
     */
    public String getAppFlowType() {
        return appFlowType;
    }

    
    /**
     * appFlowType.
     *
     * @param   appFlowType    the appFlowType to set
     * @since   JDK 1.8
     */
    public void setAppFlowType(String appFlowType) {
        this.appFlowType = appFlowType;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public List<AdvertLimitDto> getLimitFlowAppList() {
        return limitFlowAppList;
    }

    public void setLimitFlowAppList(List<AdvertLimitDto> limitFlowAppList) {
        this.limitFlowAppList = limitFlowAppList;
    }

    public List<AppPackageDto> getLimitFlowPackageList() {
        return limitFlowPackageList;
    }

    public void setLimitFlowPackageList(List<AppPackageDto> limitFlowPackageList) {
        this.limitFlowPackageList = limitFlowPackageList;
    }

    public Integer getPackageType() {
        return packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public AdvertOrientationPackageDto(String packageName) {
        this.packageName = packageName;
    }

    public AdvertOrientationPackageDto() {
    }

    public String getLimitAppIds() {
        return limitAppIds;
    }

    public void setLimitAppIds(String limitAppIds) {
        this.limitAppIds = limitAppIds;
    }

    /**
     * budgetPerDay.
     *
     * @return the budgetPerDay
     */
    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    /**
     * budgetPerDay.
     *
     * @param budgetPerDay the budgetPerDay to set
     */
    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    /**
     * cpaFee.
     *
     * @return the cpaFee
     */
    public Long getCpaFee() {
        return cpaFee;
    }

    /**
     * cpaFee.
     *
     * @param cpaFee the cpaFee to set
     */
    public void setCpaFee(Long cpaFee) {
        this.cpaFee = cpaFee;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getRegionIds() {
        return regionIds;
    }

    public void setRegionIds(String regionIds) {
        this.regionIds = regionIds;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getPhoneLevel() {
        return phoneLevel;
    }

    public void setPhoneLevel(String phoneLevel) {
        this.phoneLevel = phoneLevel;
    }

    public String getDirectionalNum() {
        return directionalNum;
    }

    public void setDirectionalNum(String directionalNum) {
        this.directionalNum = directionalNum;
    }

    public List<AdvertPlanPeriodDto> getPeriods() {
        return periods;
    }

    public void setPeriods(List<AdvertPlanPeriodDto> periods) {
        this.periods = periods;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public String getNetworkType() {
        return networkType;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getOperators() {
        return operators;
    }

    public void setOperators(String operators) {
        this.operators = operators;
    }

    public String getAgeRegion() {
        return ageRegion;
    }

    public void setAgeRegion(String ageRegion) {
        this.ageRegion = ageRegion;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getBannedTagNums() {
        return bannedTagNums;
    }

    public void setBannedTagNums(String bannedTagNums) {
        this.bannedTagNums = bannedTagNums;
    }

    public List<RspAdvertTargetAppDetail> getTargetApp() {
        return targetApp;
    }

    public void setTargetApp(List<RspAdvertTargetAppDetail> targetApp) {
        this.targetApp = targetApp;
    }

    public List<AdvertLimitDto> getAdvertLimit() {
        return advertLimit;
    }

    public void setAdvertLimit(List<AdvertLimitDto> advertLimit) {
        this.advertLimit = advertLimit;
    }

    public String getTargetAppIds() {
        return targetAppIds;
    }

    public void setTargetAppIds(String targetAppIds) {
        this.targetAppIds = targetAppIds;
    }

    public String getMaterialIds() {
        return materialIds;
    }

    public void setMaterialIds(String materialIds) {
        this.materialIds = materialIds;
    }

    public List<Long> getLimitFlowAppPackageIds() {
        return limitFlowAppPackageIds;
    }

    public void setLimitFlowAppPackageIds(List<Long> limitFlowAppPackageIds) {
        this.limitFlowAppPackageIds = limitFlowAppPackageIds;
    }

    public String getCrowdTradePackageTag() {
        return crowdTradePackageTag;
    }

    public void setCrowdTradePackageTag(String crowdTradePackageTag) {
        this.crowdTradePackageTag = crowdTradePackageTag;
    }

    public Date getSupportEndTime() {
        return supportEndTime;
    }

    public void setSupportEndTime(Date supportEndTime) {
        this.supportEndTime = supportEndTime;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
