/**
 * Project Name:tuia-core-api<br>
 * File Name:AppDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月9日下午4:35:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 新媒体策略配置,接口数据 date: 2017年4月14日 下午2:50:24 <br/>
 *
 * @author chencheng
 * @version
 */
public class AppFlowStrategyDto extends BaseDto {

    private static final long serialVersionUID = -1751669744543928318L;

    /** 策略id. */
    private Long              strategyId;

    /** 媒体id. */
    private Long              appId;

    /** 屏蔽的推广url. */
    private String            shieldUrl;

    /** 生效地域,为null表示不限. */
    private String            validRegions;

    /** 有效周期时段. */
    private String            validPeriod;

    /** 失效开始时间. */
    private String            invalidStartTime;

    /** 失效結束时间. */
    private String            invalidEndTime;

    /** 福袋开关(0表示关，1表示开). */
    private int               switchLuckybag;

    /** 策略开关(0表示关，1表示开). */
    private int               switchStrategy;

    /** 代理开关(0表示关，1表示开). */
    private int               switchProxy;

    /** 是否覆盖默认策略(0表示否，1表示是). */
    private int               coverDefaultStrategy;

    /** 是否广告定制(0表示否，1表示是). */
    private int               switchAppWhiteAdvert;

    /** 新媒体策略屏蔽标签. */
    private String            flowBannedTags;

    /** 新媒体策略广告标签. */
    private String            flowBannedAdvertTags;

    /** 落地页标签. */
    private String            promoteUrlTagNums;

    /** 是否已处理为广告位维度 **/
    private int               isHandledSlot;

    /** 是否已初始化白名单 **/
    private Integer           isHandledWhiteList;

    public Integer getIsHandledWhiteList() {
        return isHandledWhiteList;
    }

    public void setIsHandledWhiteList(Integer isHandledWhiteList) {
        this.isHandledWhiteList = isHandledWhiteList;
    }

    public int getIsHandledSlot() {
        return isHandledSlot;
    }

    public void setIsHandledSlot(int isHandledSlot) {
        this.isHandledSlot = isHandledSlot;
    }

    /**
     * promoteUrlTagNums.
     *
     * @return the promoteUrlTagNums
     * @since JDK 1.8
     */
    public String getPromoteUrlTagNums() {
        return promoteUrlTagNums;
    }

    /**
     * promoteUrlTagNums.
     *
     * @param promoteUrlTagNums the promoteUrlTagNums to set
     * @since JDK 1.8
     */
    public void setPromoteUrlTagNums(String promoteUrlTagNums) {
        this.promoteUrlTagNums = promoteUrlTagNums;
    }

    /**
     * switchAppWhiteAdvert.
     *
     * @return the switchAppWhiteAdvert
     */
    public int getSwitchAppWhiteAdvert() {
        return switchAppWhiteAdvert;
    }

    /**
     * switchAppWhiteAdvert.
     *
     * @param switchAppWhiteAdvert the switchAppWhiteAdvert to set
     */
    public void setSwitchAppWhiteAdvert(int switchAppWhiteAdvert) {
        this.switchAppWhiteAdvert = switchAppWhiteAdvert;
    }

    /**
     * strategyId.
     *
     * @return the strategyId
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * strategyId.
     *
     * @param strategyId the strategyId to set
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * switchProxy.
     *
     * @return the switchProxy
     */
    public int getSwitchProxy() {
        return switchProxy;
    }

    /**
     * switchProxy.
     *
     * @param switchProxy the switchProxy to set
     */
    public void setSwitchProxy(int switchProxy) {
        this.switchProxy = switchProxy;
    }

    /**
     * coverDefaultStrategy.
     *
     * @return the coverDefaultStrategy
     */
    public int getCoverDefaultStrategy() {
        return coverDefaultStrategy;
    }

    /**
     * coverDefaultStrategy.
     *
     * @param coverDefaultStrategy the coverDefaultStrategy to set
     */
    public void setCoverDefaultStrategy(int coverDefaultStrategy) {
        this.coverDefaultStrategy = coverDefaultStrategy;
    }

    /**
     * flowBannedTags.
     *
     * @return the flowBannedTags
     */
    public String getFlowBannedTags() {
        return flowBannedTags;
    }

    /**
     * flowBannedTags.
     *
     * @param flowBannedTags the flowBannedTags to set
     */
    public void setFlowBannedTags(String flowBannedTags) {
        this.flowBannedTags = flowBannedTags;
    }

    /**
     * flowBannedAdvertTags.
     *
     * @return the flowBannedAdvertTags
     */
    public String getFlowBannedAdvertTags() {
        return flowBannedAdvertTags;
    }

    /**
     * flowBannedAdvertTags.
     *
     * @param flowBannedAdvertTags the flowBannedAdvertTags to set
     */
    public void setFlowBannedAdvertTags(String flowBannedAdvertTags) {
        this.flowBannedAdvertTags = flowBannedAdvertTags;
    }

    /**
     * switchLuckybag.
     *
     * @return the switchLuckybag
     */
    public int getSwitchLuckybag() {
        return switchLuckybag;
    }

    /**
     * switchLuckybag.
     *
     * @param switchLuckybag the switchLuckybag to set
     */
    public void setSwitchLuckybag(int switchLuckybag) {
        this.switchLuckybag = switchLuckybag;
    }

    /**
     * switchStrategy.
     *
     * @return the switchStrategy
     */
    public int getSwitchStrategy() {
        return switchStrategy;
    }

    /**
     * switchStrategy.
     *
     * @param switchStrategy the switchStrategy to set
     */
    public void setSwitchStrategy(int switchStrategy) {
        this.switchStrategy = switchStrategy;
    }

    /**
     * appId.
     *
     * @return the appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * shieldUrl.
     *
     * @return the shieldUrl
     */
    public String getShieldUrl() {
        return shieldUrl;
    }

    /**
     * shieldUrl.
     *
     * @param shieldUrl the shieldUrl to set
     */
    public void setShieldUrl(String shieldUrl) {
        this.shieldUrl = shieldUrl;
    }

    /**
     * validRegions.
     *
     * @return the validRegions
     */
    public String getValidRegions() {
        return validRegions;
    }

    /**
     * validRegions.
     *
     * @param validRegions the validRegions to set
     */
    public void setValidRegions(String validRegions) {
        this.validRegions = validRegions;
    }

    /**
     * validPeriod.
     *
     * @return the validPeriod
     */
    public String getValidPeriod() {
        return validPeriod;
    }

    /**
     * validPeriod.
     *
     * @param validPeriod the validPeriod to set
     */
    public void setValidPeriod(String validPeriod) {
        this.validPeriod = validPeriod;
    }

    /**
     * invalidStartTime.
     *
     * @return the invalidStartTime
     */
    public String getInvalidStartTime() {
        return invalidStartTime;
    }

    /**
     * invalidStartTime.
     *
     * @param invalidStartTime the invalidStartTime to set
     */
    public void setInvalidStartTime(String invalidStartTime) {
        this.invalidStartTime = invalidStartTime;
    }

    /**
     * invalidEndTime.
     *
     * @return the invalidEndTime
     */
    public String getInvalidEndTime() {
        return invalidEndTime;
    }

    /**
     * invalidEndTime.
     *
     * @param invalidEndTime the invalidEndTime to set
     */
    public void setInvalidEndTime(String invalidEndTime) {
        this.invalidEndTime = invalidEndTime;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
