package cn.com.duiba.tuia.core.api.dto;

import java.util.Date;

/**
 * ClassName: CouponRecoveryLogDO <br/>
 * Function: 券码回收记录表. <br/>
 * date: 2016年8月9日 上午11:59:53 <br/>
 *
 * @author zufengze
 * @version
 * @since JDK 1.7
 */
public class CouponRecoveryLogDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID  = -5303583362930224959L;

    /** 券码回收状态：回收中. */
    public static final int   RECOVERY_ING      = 0;

    /** 券码回收状态：全部回收. */
    public static final int   RECOVERY_FINISHED = 1;

    /** 码回收状态：部分回收. */
    public static final int   RECOVERY_PART     = 2;

    /** 码回收状态：回收失败. */
    public static final int   RECOVERY_FAIL     = 3;

    /** 广告Id. */
    private Long              advertId;

    /** 券码回收文件地址. */
    private String            fileUrl;

    /** 回收的券码数量. */
    private Long              recoveryNum;

    /** 回收状态 0-回收中 1-全部回收 2-部分回收 3-回收失败. */
    private Integer           status;

    /** 回收备注. */
    private String            remarks;

    /** 商品中心回收券码记录ID. */
    private Long              logId;

    /** The batch id. */
    private Long              batchId;

    /**
     * date类型数据库创建时间
     */
    private Date createDate;

    /**
     * 回收时间
     */
    private String recoveryDate;

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getRecoveryDate() {
        return recoveryDate;
    }

    public void setRecoveryDate(String recoveryDate) {
        this.recoveryDate = recoveryDate;
    }

    /**
     * batchId.
     *
     * @return the batchId
     * @since JDK 1.6
     */
    public Long getBatchId() {
        return batchId;
    }

    /**
     * batchId.
     *
     * @param batchId the batchId to set
     * @since JDK 1.6
     */
    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }

    /**
     * logId.
     *
     * @return the logId
     * @since JDK 1.6
     */
    public Long getLogId() {
        return logId;
    }

    /**
     * logId.
     *
     * @param logId the logId to set
     * @since JDK 1.6
     */
    public void setLogId(Long logId) {
        this.logId = logId;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the file url.
     *
     * @return the file url
     */
    public String getFileUrl() {
        return fileUrl;
    }

    /**
     * Sets the file url.
     *
     * @param fileUrl the file url
     */
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    /**
     * Gets the recovery num.
     *
     * @return the recovery num
     */
    public Long getRecoveryNum() {
        return recoveryNum;
    }

    /**
     * Sets the recovery num.
     *
     * @param recoveryNum the recovery num
     */
    public void setRecoveryNum(Long recoveryNum) {
        this.recoveryNum = recoveryNum;
    }

    /**
     * Gets the status.
     *
     * @return the status
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * Sets the status.
     *
     * @param status the status
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * Gets the remarks.
     *
     * @return the remarks
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * Sets the remarks.
     *
     * @param remarks the remarks
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    /**
     * To string.
     *
     * @return the string
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CouponRecoveryLogDO [advertId=");
        builder.append(advertId);
        builder.append(", fileUrl=");
        builder.append(fileUrl);
        builder.append(", recoveryNum=");
        builder.append(recoveryNum);
        builder.append(", status=");
        builder.append(status);
        builder.append(", remarks=");
        builder.append(remarks);
        builder.append(", getId()=");
        builder.append(getId());
        builder.append(", getGmtCreate()=");
        builder.append(getGmtCreate());
        builder.append(", getGmtModified()=");
        builder.append(getGmtModified());
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append(", getClass()=");
        builder.append(getClass());
        builder.append(", hashCode()=");
        builder.append(hashCode());
        builder.append("]");
        return builder.toString();
    }

}
