package cn.com.duiba.tuia.core.api.dto.advert;

import java.io.Serializable;

/**
 * @Description: 广告落地页数据巡查对象
 *
 * @Author: chensong
 * @Create: 2018-10-22
 */
public class AdvertPatrolDto implements Serializable {

    private static final long serialVersionUID = 8347675022277100895L;

    /**
     * 广告落地页链接类型
     */
    public static final int ADVERT_PROMOTE_URL_TYPE = 1;

    /**
     * 落地页内的跳转链接类型
     */
    public static final int JUMP_PROMOTE_URL_TYPE = 2;

    /**
     * 广告主id
     */
    private Long advertiserId;

    /**
     *  广告ID
     */
    private Long advertId;

    /**
     *  广告名称
     */
    private String advertName;

    /**
     *  落地页url
     */
    private String promoteUrl;

    /**
     * AE名称
     */
    private String aeName;

    /**
     * AE id
     */
    private Long aeId;

    /**
     * 销售名称
     */
    private String sellName;

    /**
     * 销售id
     */
    private Long sellId;

    /**
     *广告主名称
     */
    private String companyName;

    /**
     * 巡查链接类型 1-落地页 2-跳转链接
     */
    private int promoteType;

    /**
     * 行业标签
     */
    private String tradeTagNum;

    /**
     * 一级代理商id
     */
    private Long agentId;

    public Long getAdvertiserId() {
        return advertiserId;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public String getTradeTagNum() {
        return tradeTagNum;
    }

    public void setTradeTagNum(String tradeTagNum) {
        this.tradeTagNum = tradeTagNum;
    }

    public int getPromoteType() {
        return promoteType;
    }

    public void setPromoteType(int promoteType) {
        this.promoteType = promoteType;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public Long getAeId() {
        return aeId;
    }

    public void setAeId(Long aeId) {
        this.aeId = aeId;
    }

    public String getSellName() {
        return sellName;
    }

    public void setSellName(String sellName) {
        this.sellName = sellName;
    }

    public Long getSellId() {
        return sellId;
    }

    public void setSellId(Long sellId) {
        this.sellId = sellId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
}
