package cn.com.duiba.tuia.core.api.dto.advertiser;

import java.util.Date;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * Created by huangch on 2017/8/21 15:54 description:
 *
 * @since JDK 1.6
 */
public class AccountFinanceStatisticsDayDto extends BaseDto {

    private static final long serialVersionUID = 1176688887245220164L;

    /**
     * 当前日期
     */
    private Date              curDate;

    /**
     * 广告主账户ID
     */
    private Long              accountId;

    /**
     * 广告主账户资金流水记录ID
     */
    private Long              financeId;

    /**
     * 广告主账户入账金额
     */
    private Long              balanceIn;

    /**
     * 广告主账户支出金额
     */
    private Long              balanceOut;

    /**
     * 广告主账户资金流动类型 记录方式:AB,A位1存入,2支出;10-充值;11-退款等;20-广告扣费
     */
    private Integer           type;

    // 同上,做兼容
    private Integer           recordType;

    /**
     * 广告主账户资金流动备注
     */
    private String            remark;

    /**
     * 消费修正记录的主键
     */
    private Long              consumerCorrectionId;

    /**
     * 当日的总余额
     */
    private Long              balance;

    /**
     * 返货的比率
     */
    private Long           cashBackRate;

    /**
     * 返货的收入
     */
    private Long              cashBackIn;
    /**
     * 返货的消耗
     */
    private Long              cashBackOut;

    private Integer           effectiveMainType;

    public Integer getEffectiveMainType() {
        return effectiveMainType;
    }

    public void setEffectiveMainType(Integer effectiveMainType) {
        this.effectiveMainType = effectiveMainType;
    }

    public Long getCashBackIn() {
        return cashBackIn;
    }

    public void setCashBackIn(Long cashBackIn) {
        this.cashBackIn = cashBackIn;
    }

    public Long getCashBackOut() {
        return cashBackOut;
    }

    public void setCashBackOut(Long cashBackOut) {
        this.cashBackOut = cashBackOut;
    }

    public Integer getRecordType() {
        return recordType;
    }

    public void setRecordType(Integer recordType) {
        this.recordType = recordType;
    }

    public Long getCashBackRate() {
        return cashBackRate;
    }

    public void setCashBackRate(Long cashBackRate) {
        this.cashBackRate = cashBackRate;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getFinanceId() {
        return financeId;
    }

    public void setFinanceId(Long financeId) {
        this.financeId = financeId;
    }

    public Long getBalanceIn() {
        return balanceIn;
    }

    public void setBalanceIn(Long balanceIn) {
        this.balanceIn = balanceIn;
    }

    public Long getBalanceOut() {
        return balanceOut;
    }

    public void setBalanceOut(Long balanceOut) {
        this.balanceOut = balanceOut;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getConsumerCorrectionId() {
        return consumerCorrectionId;
    }

    public void setConsumerCorrectionId(Long consumerCorrectionId) {
        this.consumerCorrectionId = consumerCorrectionId;
    }
}
