package cn.com.duiba.tuia.core.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.account.query.AccountBalanceRecordQueryDto;
import cn.com.duiba.tuia.core.api.dto.account.query.AccountFinanceQueryDto;
import cn.com.duiba.tuia.core.api.dto.account.query.AdvertiserConsumeQueryDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AccountBalanceRecordQueryResultDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AccountFinanceRecordQueryResultDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AdvertiserConsumeQueryResultDto;
import cn.com.duiba.tuia.core.api.dto.finance.ReconciliationDataResponse;

import java.util.List;
import java.util.concurrent.ExecutionException;

@AdvancedFeignClient
public interface RemoteAccountDataService {

    AdvertiserConsumeQueryResultDto getAdvertiserConsumeData(AdvertiserConsumeQueryDto advertiserConsumeQueryDto) throws ExecutionException;

    AccountBalanceRecordQueryResultDto getAccountBalanceRecordData(AccountBalanceRecordQueryDto accountBalanceRecordQueryDto) throws ExecutionException;

    List<AccountBalanceRecordQueryResultDto.AccountBalanceRecordDto> exportAccountBalanceRecordData(AccountBalanceRecordQueryDto accountBalanceRecordQueryDto) throws ExecutionException;

    ReconciliationDataResponse getAccountFinanceRecord(AccountFinanceQueryDto accountFinanceQueryDto) throws ExecutionException;
}
